/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Output
implements ToCopyableBuilder<Builder, Output> {
    private final String outputKey;
    private final String outputValue;
    private final String description;
    private final String exportName;

    private Output(BuilderImpl builder) {
        this.outputKey = builder.outputKey;
        this.outputValue = builder.outputValue;
        this.description = builder.description;
        this.exportName = builder.exportName;
    }

    public String outputKey() {
        return this.outputKey;
    }

    public String outputValue() {
        return this.outputValue;
    }

    public String description() {
        return this.description;
    }

    public String exportName() {
        return this.exportName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.outputKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Output)) {
            return false;
        }
        Output other = (Output)obj;
        return Objects.equals(this.outputKey(), other.outputKey()) && Objects.equals(this.outputValue(), other.outputValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.exportName(), other.exportName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.outputKey() != null) {
            sb.append("OutputKey: ").append(this.outputKey()).append(",");
        }
        if (this.outputValue() != null) {
            sb.append("OutputValue: ").append(this.outputValue()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.exportName() != null) {
            sb.append("ExportName: ").append(this.exportName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OutputKey": {
                return Optional.of(clazz.cast(this.outputKey()));
            }
            case "OutputValue": {
                return Optional.of(clazz.cast(this.outputValue()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "ExportName": {
                return Optional.of(clazz.cast(this.exportName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String outputKey;
        private String outputValue;
        private String description;
        private String exportName;

        private BuilderImpl() {
        }

        private BuilderImpl(Output model) {
            this.outputKey(model.outputKey);
            this.outputValue(model.outputValue);
            this.description(model.description);
            this.exportName(model.exportName);
        }

        public final String getOutputKey() {
            return this.outputKey;
        }

        @Override
        public final Builder outputKey(String outputKey) {
            this.outputKey = outputKey;
            return this;
        }

        public final void setOutputKey(String outputKey) {
            this.outputKey = outputKey;
        }

        public final String getOutputValue() {
            return this.outputValue;
        }

        @Override
        public final Builder outputValue(String outputValue) {
            this.outputValue = outputValue;
            return this;
        }

        public final void setOutputValue(String outputValue) {
            this.outputValue = outputValue;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getExportName() {
            return this.exportName;
        }

        @Override
        public final Builder exportName(String exportName) {
            this.exportName = exportName;
            return this;
        }

        public final void setExportName(String exportName) {
            this.exportName = exportName;
        }

        public Output build() {
            return new Output(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Output> {
        public Builder outputKey(String var1);

        public Builder outputValue(String var1);

        public Builder description(String var1);

        public Builder exportName(String var1);
    }
}

