/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;

public class ExecuteChangeSetRequestMarshaller
implements Marshaller<Request<ExecuteChangeSetRequest>, ExecuteChangeSetRequest> {
    public Request<ExecuteChangeSetRequest> marshall(ExecuteChangeSetRequest executeChangeSetRequest) {
        if (executeChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)executeChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "ExecuteChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (executeChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)executeChangeSetRequest.changeSetName()));
        }
        if (executeChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)executeChangeSetRequest.stackName()));
        }
        if (executeChangeSetRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)executeChangeSetRequest.clientRequestToken()));
        }
        return request;
    }
}

