/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;

public class DeleteStackInstancesRequestMarshaller
implements Marshaller<Request<DeleteStackInstancesRequest>, DeleteStackInstancesRequest> {
    public Request<DeleteStackInstancesRequest> marshall(DeleteStackInstancesRequest deleteStackInstancesRequest) {
        StackSetOperationPreferences operationPreferences;
        List<String> regionsList;
        List<String> accountsList;
        if (deleteStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString((String)deleteStackInstancesRequest.stackSetName()));
        }
        if ((accountsList = deleteStackInstancesRequest.accounts()) != null) {
            if (!accountsList.isEmpty()) {
                int accountsListIndex = 1;
                for (String string : accountsList) {
                    if (string != null) {
                        request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)string));
                    }
                    ++accountsListIndex;
                }
            } else {
                request.addParameter("Accounts", "");
            }
        }
        if ((regionsList = deleteStackInstancesRequest.regions()) != null) {
            if (!regionsList.isEmpty()) {
                int regionsListIndex = 1;
                for (String regionsListValue : regionsList) {
                    if (regionsListValue != null) {
                        request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString((String)regionsListValue));
                    }
                    ++regionsListIndex;
                }
            } else {
                request.addParameter("Regions", "");
            }
        }
        if ((operationPreferences = deleteStackInstancesRequest.operationPreferences()) != null) {
            List<String> list = operationPreferences.regionOrder();
            if (list != null) {
                if (!list.isEmpty()) {
                    int regionOrderListIndex = 1;
                    for (String regionOrderListValue : list) {
                        if (regionOrderListValue != null) {
                            request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString((String)regionOrderListValue));
                        }
                        ++regionOrderListIndex;
                    }
                } else {
                    request.addParameter("OperationPreferences.RegionOrder", "");
                }
            }
            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger((Integer)operationPreferences.failureToleranceCount()));
            }
            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger((Integer)operationPreferences.failureTolerancePercentage()));
            }
            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger((Integer)operationPreferences.maxConcurrentCount()));
            }
            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger((Integer)operationPreferences.maxConcurrentPercentage()));
            }
        }
        if (deleteStackInstancesRequest.retainStacks() != null) {
            request.addParameter("RetainStacks", StringUtils.fromBoolean((Boolean)deleteStackInstancesRequest.retainStacks()));
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)deleteStackInstancesRequest.operationId()));
        return request;
    }
}

