/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListStacksRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStacksResponse;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;

public final class ListStacksPaginator
implements SdkIterable<ListStacksResponse> {
    private final CloudFormationClient client;
    private final ListStacksRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListStacksPaginator(CloudFormationClient client, ListStacksRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStacksResponseFetcher();
    }

    public Iterator<ListStacksResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<StackSummary> stackSummaries() {
        Function<ListStacksResponse, Iterator> getIterator = response -> response != null ? response.stackSummaries().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListStacksResponseFetcher
    implements NextPageFetcher<ListStacksResponse> {
        private ListStacksResponseFetcher() {
        }

        public boolean hasNextPage(ListStacksResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListStacksResponse nextPage(ListStacksResponse previousPage) {
            if (previousPage == null) {
                return ListStacksPaginator.this.client.listStacks(ListStacksPaginator.this.firstRequest);
            }
            return ListStacksPaginator.this.client.listStacks((ListStacksRequest)((Object)ListStacksPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

