/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesRequest;
import software.amazon.awssdk.services.cloudformation.model.ListStackResourcesResponse;
import software.amazon.awssdk.services.cloudformation.model.StackResourceSummary;

public final class ListStackResourcesPaginator
implements SdkIterable<ListStackResourcesResponse> {
    private final CloudFormationClient client;
    private final ListStackResourcesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListStackResourcesPaginator(CloudFormationClient client, ListStackResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStackResourcesResponseFetcher();
    }

    public Iterator<ListStackResourcesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<StackResourceSummary> stackResourceSummaries() {
        Function<ListStackResourcesResponse, Iterator> getIterator = response -> response != null ? response.stackResourceSummaries().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListStackResourcesResponseFetcher
    implements NextPageFetcher<ListStackResourcesResponse> {
        private ListStackResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListStackResourcesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListStackResourcesResponse nextPage(ListStackResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListStackResourcesPaginator.this.client.listStackResources(ListStackResourcesPaginator.this.firstRequest);
            }
            return ListStackResourcesPaginator.this.client.listStackResources((ListStackResourcesRequest)((Object)ListStackResourcesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

