/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudformation.CloudFormationClient;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsRequest;
import software.amazon.awssdk.services.cloudformation.model.DescribeStackEventsResponse;
import software.amazon.awssdk.services.cloudformation.model.StackEvent;

public final class DescribeStackEventsPaginator
implements SdkIterable<DescribeStackEventsResponse> {
    private final CloudFormationClient client;
    private final DescribeStackEventsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeStackEventsPaginator(CloudFormationClient client, DescribeStackEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeStackEventsResponseFetcher();
    }

    public Iterator<DescribeStackEventsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<StackEvent> stackEvents() {
        Function<DescribeStackEventsResponse, Iterator> getIterator = response -> response != null ? response.stackEvents().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeStackEventsResponseFetcher
    implements NextPageFetcher<DescribeStackEventsResponse> {
        private DescribeStackEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeStackEventsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeStackEventsResponse nextPage(DescribeStackEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeStackEventsPaginator.this.client.describeStackEvents(DescribeStackEventsPaginator.this.firstRequest);
            }
            return DescribeStackEventsPaginator.this.client.describeStackEvents((DescribeStackEventsRequest)((Object)DescribeStackEventsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

