/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.TemplateParameter;
import software.amazon.awssdk.services.cloudformation.model.TemplateParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.TransformsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ValidateTemplateResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ValidateTemplateResponse> {
    private final List<TemplateParameter> parameters;
    private final String description;
    private final List<String> capabilities;
    private final String capabilitiesReason;
    private final List<String> declaredTransforms;

    private ValidateTemplateResponse(BuilderImpl builder) {
        this.parameters = builder.parameters;
        this.description = builder.description;
        this.capabilities = builder.capabilities;
        this.capabilitiesReason = builder.capabilitiesReason;
        this.declaredTransforms = builder.declaredTransforms;
    }

    public List<TemplateParameter> parameters() {
        return this.parameters;
    }

    public String description() {
        return this.description;
    }

    public List<Capability> capabilities() {
        return TypeConverter.convert(this.capabilities, Capability::fromValue);
    }

    public List<String> capabilitiesStrings() {
        return this.capabilities;
    }

    public String capabilitiesReason() {
        return this.capabilitiesReason;
    }

    public List<String> declaredTransforms() {
        return this.declaredTransforms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.capabilitiesReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.declaredTransforms());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidateTemplateResponse)) {
            return false;
        }
        ValidateTemplateResponse other = (ValidateTemplateResponse)((Object)obj);
        return Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.capabilitiesStrings(), other.capabilitiesStrings()) && Objects.equals(this.capabilitiesReason(), other.capabilitiesReason()) && Objects.equals(this.declaredTransforms(), other.declaredTransforms());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.capabilitiesStrings() != null) {
            sb.append("Capabilities: ").append(this.capabilitiesStrings()).append(",");
        }
        if (this.capabilitiesReason() != null) {
            sb.append("CapabilitiesReason: ").append(this.capabilitiesReason()).append(",");
        }
        if (this.declaredTransforms() != null) {
            sb.append("DeclaredTransforms: ").append(this.declaredTransforms()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "Capabilities": {
                return Optional.of(clazz.cast(this.capabilitiesStrings()));
            }
            case "CapabilitiesReason": {
                return Optional.of(clazz.cast(this.capabilitiesReason()));
            }
            case "DeclaredTransforms": {
                return Optional.of(clazz.cast(this.declaredTransforms()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<TemplateParameter> parameters;
        private String description;
        private List<String> capabilities;
        private String capabilitiesReason;
        private List<String> declaredTransforms;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidateTemplateResponse model) {
            this.parameters(model.parameters);
            this.description(model.description);
            this.capabilities(model.capabilities);
            this.capabilitiesReason(model.capabilitiesReason);
            this.declaredTransforms(model.declaredTransforms);
        }

        public final Collection<TemplateParameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(TemplateParameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<TemplateParameter> parameters) {
            this.parameters = TemplateParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(TemplateParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<TemplateParameter.BuilderImpl> parameters) {
            this.parameters = TemplateParametersCopier.copyFromBuilder(parameters);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            this.capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        public final String getCapabilitiesReason() {
            return this.capabilitiesReason;
        }

        @Override
        public final Builder capabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
            return this;
        }

        public final void setCapabilitiesReason(String capabilitiesReason) {
            this.capabilitiesReason = capabilitiesReason;
        }

        public final Collection<String> getDeclaredTransforms() {
            return this.declaredTransforms;
        }

        @Override
        public final Builder declaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder declaredTransforms(String ... declaredTransforms) {
            this.declaredTransforms(Arrays.asList(declaredTransforms));
            return this;
        }

        public final void setDeclaredTransforms(Collection<String> declaredTransforms) {
            this.declaredTransforms = TransformsListCopier.copy(declaredTransforms);
        }

        public ValidateTemplateResponse build() {
            return new ValidateTemplateResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ValidateTemplateResponse> {
        public Builder parameters(Collection<TemplateParameter> var1);

        public Builder parameters(TemplateParameter ... var1);

        public Builder description(String var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilitiesReason(String var1);

        public Builder declaredTransforms(Collection<String> var1);

        public Builder declaredTransforms(String ... var1);
    }
}

