/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.DescribeChangeSetRequest;

public class DescribeChangeSetRequestMarshaller
implements Marshaller<Request<DescribeChangeSetRequest>, DescribeChangeSetRequest> {
    public Request<DescribeChangeSetRequest> marshall(DescribeChangeSetRequest describeChangeSetRequest) {
        if (describeChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "DescribeChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)describeChangeSetRequest.changeSetName()));
        }
        if (describeChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)describeChangeSetRequest.stackName()));
        }
        if (describeChangeSetRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeChangeSetRequest.nextToken()));
        }
        return request;
    }
}

