/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudformation.model.CreateStackRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;

public class CreateStackRequestMarshaller
implements Marshaller<Request<CreateStackRequest>, CreateStackRequest> {
    /*
     * WARNING - void declaration
     */
    public Request<CreateStackRequest> marshall(CreateStackRequest createStackRequest) {
        List<Tag> list;
        List<String> list2;
        List<String> capabilitiesList;
        List<String> notificationARNsList;
        List<Parameter> parametersList;
        if (createStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createStackRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createStackRequest.stackName()));
        }
        if (createStackRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createStackRequest.templateBody()));
        }
        if (createStackRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createStackRequest.templateURL()));
        }
        if ((parametersList = createStackRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parameter : parametersList) {
                    if (parameter.parameterKey() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)parameter.parameterKey()));
                    }
                    if (parameter.parameterValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parameter.parameterValue()));
                    }
                    if (parameter.usePreviousValue() != null) {
                        request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)parameter.usePreviousValue()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        if (createStackRequest.disableRollback() != null) {
            request.addParameter("DisableRollback", StringUtils.fromBoolean((Boolean)createStackRequest.disableRollback()));
        }
        if (createStackRequest.timeoutInMinutes() != null) {
            request.addParameter("TimeoutInMinutes", StringUtils.fromInteger((Integer)createStackRequest.timeoutInMinutes()));
        }
        if ((notificationARNsList = createStackRequest.notificationARNs()) != null) {
            if (!notificationARNsList.isEmpty()) {
                int notificationARNsListIndex = 1;
                for (String string : notificationARNsList) {
                    if (string != null) {
                        request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)string));
                    }
                    ++notificationARNsListIndex;
                }
            } else {
                request.addParameter("NotificationARNs", "");
            }
        }
        if ((capabilitiesList = createStackRequest.capabilitiesStrings()) != null) {
            if (!capabilitiesList.isEmpty()) {
                boolean bl = true;
                for (String string : capabilitiesList) {
                    void var6_12;
                    if (string != null) {
                        request.addParameter("Capabilities.member." + (int)var6_12, StringUtils.fromString((String)string));
                    }
                    ++var6_12;
                }
            } else {
                request.addParameter("Capabilities", "");
            }
        }
        if ((list2 = createStackRequest.resourceTypes()) != null) {
            if (!list2.isEmpty()) {
                boolean bl = true;
                for (String resourceTypesListValue : list2) {
                    void var7_18;
                    if (resourceTypesListValue != null) {
                        request.addParameter("ResourceTypes.member." + (int)var7_18, StringUtils.fromString((String)resourceTypesListValue));
                    }
                    ++var7_18;
                }
            } else {
                request.addParameter("ResourceTypes", "");
            }
        }
        if (createStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createStackRequest.roleARN()));
        }
        if (createStackRequest.onFailureString() != null) {
            request.addParameter("OnFailure", StringUtils.fromString((String)createStackRequest.onFailureString()));
        }
        if (createStackRequest.stackPolicyBody() != null) {
            request.addParameter("StackPolicyBody", StringUtils.fromString((String)createStackRequest.stackPolicyBody()));
        }
        if (createStackRequest.stackPolicyURL() != null) {
            request.addParameter("StackPolicyURL", StringUtils.fromString((String)createStackRequest.stackPolicyURL()));
        }
        if ((list = createStackRequest.tags()) != null) {
            if (!list.isEmpty()) {
                boolean bl = true;
                for (Tag tagsListValue : list) {
                    void var8_24;
                    if (tagsListValue.key() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                    }
                    if (tagsListValue.value() != null) {
                        request.addParameter("Tags.member." + (int)var8_24 + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                    }
                    ++var8_24;
                }
            } else {
                request.addParameter("Tags", "");
            }
        }
        if (createStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)createStackRequest.clientRequestToken()));
        }
        return request;
    }
}

