/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.services.cloudformation.model.RequiresRecreation;
import software.amazon.awssdk.services.cloudformation.model.ResourceAttribute;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceTargetDefinition
implements ToCopyableBuilder<Builder, ResourceTargetDefinition> {
    private final String attribute;
    private final String name;
    private final String requiresRecreation;

    private ResourceTargetDefinition(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.name = builder.name;
        this.requiresRecreation = builder.requiresRecreation;
    }

    public String attribute() {
        return this.attribute;
    }

    public String name() {
        return this.name;
    }

    public String requiresRecreation() {
        return this.requiresRecreation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.attribute() == null ? 0 : this.attribute().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.requiresRecreation() == null ? 0 : this.requiresRecreation().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceTargetDefinition)) {
            return false;
        }
        ResourceTargetDefinition other = (ResourceTargetDefinition)obj;
        if (other.attribute() == null ^ this.attribute() == null) {
            return false;
        }
        if (other.attribute() != null && !other.attribute().equals(this.attribute())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.requiresRecreation() == null ^ this.requiresRecreation() == null) {
            return false;
        }
        return other.requiresRecreation() == null || other.requiresRecreation().equals(this.requiresRecreation());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attribute() != null) {
            sb.append("Attribute: ").append(this.attribute()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.requiresRecreation() != null) {
            sb.append("RequiresRecreation: ").append(this.requiresRecreation()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String name;
        private String requiresRecreation;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceTargetDefinition model) {
            this.setAttribute(model.attribute);
            this.setName(model.name);
            this.setRequiresRecreation(model.requiresRecreation);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(ResourceAttribute attribute) {
            this.attribute(attribute.toString());
            return this;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public final void setAttribute(ResourceAttribute attribute) {
            this.attribute(attribute.toString());
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRequiresRecreation() {
            return this.requiresRecreation;
        }

        @Override
        public final Builder requiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
            return this;
        }

        @Override
        public final Builder requiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation.toString());
            return this;
        }

        public final void setRequiresRecreation(String requiresRecreation) {
            this.requiresRecreation = requiresRecreation;
        }

        public final void setRequiresRecreation(RequiresRecreation requiresRecreation) {
            this.requiresRecreation(requiresRecreation.toString());
        }

        public ResourceTargetDefinition build() {
            return new ResourceTargetDefinition(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceTargetDefinition> {
        public Builder attribute(String var1);

        public Builder attribute(ResourceAttribute var1);

        public Builder name(String var1);

        public Builder requiresRecreation(String var1);

        public Builder requiresRecreation(RequiresRecreation var1);
    }
}

