/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import software.amazon.awssdk.services.cloudformation.model.ChangeSource;
import software.amazon.awssdk.services.cloudformation.model.EvaluationType;
import software.amazon.awssdk.services.cloudformation.model.ResourceTargetDefinition;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResourceChangeDetail
implements ToCopyableBuilder<Builder, ResourceChangeDetail> {
    private final ResourceTargetDefinition target;
    private final String evaluation;
    private final String changeSource;
    private final String causingEntity;

    private ResourceChangeDetail(BuilderImpl builder) {
        this.target = builder.target;
        this.evaluation = builder.evaluation;
        this.changeSource = builder.changeSource;
        this.causingEntity = builder.causingEntity;
    }

    public ResourceTargetDefinition target() {
        return this.target;
    }

    public String evaluation() {
        return this.evaluation;
    }

    public String changeSource() {
        return this.changeSource;
    }

    public String causingEntity() {
        return this.causingEntity;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.target() == null ? 0 : this.target().hashCode());
        hashCode = 31 * hashCode + (this.evaluation() == null ? 0 : this.evaluation().hashCode());
        hashCode = 31 * hashCode + (this.changeSource() == null ? 0 : this.changeSource().hashCode());
        hashCode = 31 * hashCode + (this.causingEntity() == null ? 0 : this.causingEntity().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceChangeDetail)) {
            return false;
        }
        ResourceChangeDetail other = (ResourceChangeDetail)obj;
        if (other.target() == null ^ this.target() == null) {
            return false;
        }
        if (other.target() != null && !other.target().equals(this.target())) {
            return false;
        }
        if (other.evaluation() == null ^ this.evaluation() == null) {
            return false;
        }
        if (other.evaluation() != null && !other.evaluation().equals(this.evaluation())) {
            return false;
        }
        if (other.changeSource() == null ^ this.changeSource() == null) {
            return false;
        }
        if (other.changeSource() != null && !other.changeSource().equals(this.changeSource())) {
            return false;
        }
        if (other.causingEntity() == null ^ this.causingEntity() == null) {
            return false;
        }
        return other.causingEntity() == null || other.causingEntity().equals(this.causingEntity());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.target() != null) {
            sb.append("Target: ").append(this.target()).append(",");
        }
        if (this.evaluation() != null) {
            sb.append("Evaluation: ").append(this.evaluation()).append(",");
        }
        if (this.changeSource() != null) {
            sb.append("ChangeSource: ").append(this.changeSource()).append(",");
        }
        if (this.causingEntity() != null) {
            sb.append("CausingEntity: ").append(this.causingEntity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private ResourceTargetDefinition target;
        private String evaluation;
        private String changeSource;
        private String causingEntity;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceChangeDetail model) {
            this.setTarget(model.target);
            this.setEvaluation(model.evaluation);
            this.setChangeSource(model.changeSource);
            this.setCausingEntity(model.causingEntity);
        }

        public final ResourceTargetDefinition getTarget() {
            return this.target;
        }

        @Override
        public final Builder target(ResourceTargetDefinition target) {
            this.target = target;
            return this;
        }

        public final void setTarget(ResourceTargetDefinition target) {
            this.target = target;
        }

        public final String getEvaluation() {
            return this.evaluation;
        }

        @Override
        public final Builder evaluation(String evaluation) {
            this.evaluation = evaluation;
            return this;
        }

        @Override
        public final Builder evaluation(EvaluationType evaluation) {
            this.evaluation(evaluation.toString());
            return this;
        }

        public final void setEvaluation(String evaluation) {
            this.evaluation = evaluation;
        }

        public final void setEvaluation(EvaluationType evaluation) {
            this.evaluation(evaluation.toString());
        }

        public final String getChangeSource() {
            return this.changeSource;
        }

        @Override
        public final Builder changeSource(String changeSource) {
            this.changeSource = changeSource;
            return this;
        }

        @Override
        public final Builder changeSource(ChangeSource changeSource) {
            this.changeSource(changeSource.toString());
            return this;
        }

        public final void setChangeSource(String changeSource) {
            this.changeSource = changeSource;
        }

        public final void setChangeSource(ChangeSource changeSource) {
            this.changeSource(changeSource.toString());
        }

        public final String getCausingEntity() {
            return this.causingEntity;
        }

        @Override
        public final Builder causingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
            return this;
        }

        public final void setCausingEntity(String causingEntity) {
            this.causingEntity = causingEntity;
        }

        public ResourceChangeDetail build() {
            return new ResourceChangeDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResourceChangeDetail> {
        public Builder target(ResourceTargetDefinition var1);

        public Builder evaluation(String var1);

        public Builder evaluation(EvaluationType var1);

        public Builder changeSource(String var1);

        public Builder changeSource(ChangeSource var1);

        public Builder causingEntity(String var1);
    }
}

