/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudformation.model.AccountLimit;
import software.amazon.awssdk.services.cloudformation.model.AccountLimitListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAccountLimitsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAccountLimitsResponse> {
    private final List<AccountLimit> accountLimits;
    private final String nextToken;

    private DescribeAccountLimitsResponse(BuilderImpl builder) {
        this.accountLimits = builder.accountLimits;
        this.nextToken = builder.nextToken;
    }

    public List<AccountLimit> accountLimits() {
        return this.accountLimits;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.accountLimits() == null ? 0 : this.accountLimits().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountLimitsResponse)) {
            return false;
        }
        DescribeAccountLimitsResponse other = (DescribeAccountLimitsResponse)((Object)obj);
        if (other.accountLimits() == null ^ this.accountLimits() == null) {
            return false;
        }
        if (other.accountLimits() != null && !other.accountLimits().equals(this.accountLimits())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.accountLimits() != null) {
            sb.append("AccountLimits: ").append(this.accountLimits()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<AccountLimit> accountLimits;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountLimitsResponse model) {
            this.setAccountLimits(model.accountLimits);
            this.setNextToken(model.nextToken);
        }

        public final Collection<AccountLimit> getAccountLimits() {
            return this.accountLimits;
        }

        @Override
        public final Builder accountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accountLimits(AccountLimit ... accountLimits) {
            this.accountLimits(Arrays.asList(accountLimits));
            return this;
        }

        public final void setAccountLimits(Collection<AccountLimit> accountLimits) {
            this.accountLimits = AccountLimitListCopier.copy(accountLimits);
        }

        @SafeVarargs
        public final void setAccountLimits(AccountLimit ... accountLimits) {
            this.accountLimits(Arrays.asList(accountLimits));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeAccountLimitsResponse build() {
            return new DescribeAccountLimitsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAccountLimitsResponse> {
        public Builder accountLimits(Collection<AccountLimit> var1);

        public Builder accountLimits(AccountLimit ... var1);

        public Builder nextToken(String var1);
    }
}

