/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.UpdateStackSetRequest;

public class UpdateStackSetRequestMarshaller
implements Marshaller<Request<UpdateStackSetRequest>, UpdateStackSetRequest> {
    public Request<UpdateStackSetRequest> marshall(UpdateStackSetRequest updateStackSetRequest) {
        if (updateStackSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)updateStackSetRequest, "CloudFormationClient");
        request.addParameter("Action", "UpdateStackSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateStackSetRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)updateStackSetRequest.stackSetName()));
        }
        if (updateStackSetRequest.description() != null) {
            request.addParameter("Description", StringConversion.fromString((String)updateStackSetRequest.description()));
        }
        if (updateStackSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)updateStackSetRequest.templateBody()));
        }
        if (updateStackSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)updateStackSetRequest.templateURL()));
        }
        if (updateStackSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringConversion.fromBoolean((Boolean)updateStackSetRequest.usePreviousTemplate()));
        }
        if (updateStackSetRequest.parameters().isEmpty() && !(updateStackSetRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!updateStackSetRequest.parameters().isEmpty() && !(updateStackSetRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = updateStackSetRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringConversion.fromString((String)parametersListValue.parameterKey()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                }
                if (parametersListValue.resolvedValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ResolvedValue", StringConversion.fromString((String)parametersListValue.resolvedValue()));
                }
                ++parametersListIndex;
            }
        }
        if (updateStackSetRequest.capabilitiesAsStrings().isEmpty() && !(updateStackSetRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            request.addParameter("Capabilities", "");
        } else if (!updateStackSetRequest.capabilitiesAsStrings().isEmpty() && !(updateStackSetRequest.capabilitiesAsStrings() instanceof SdkAutoConstructList)) {
            List<String> capabilitiesList = updateStackSetRequest.capabilitiesAsStrings();
            int capabilitiesListIndex = 1;
            for (String capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringConversion.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if (updateStackSetRequest.tags().isEmpty() && !(updateStackSetRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!updateStackSetRequest.tags().isEmpty() && !(updateStackSetRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = updateStackSetRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        StackSetOperationPreferences operationPreferences = updateStackSetRequest.operationPreferences();
        if (operationPreferences != null) {
            if (operationPreferences.regionOrder().isEmpty() && !(operationPreferences.regionOrder() instanceof SdkAutoConstructList)) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            } else if (!operationPreferences.regionOrder().isEmpty() && !(operationPreferences.regionOrder() instanceof SdkAutoConstructList)) {
                List<String> regionOrderList = operationPreferences.regionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringConversion.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringConversion.fromInteger((Integer)operationPreferences.failureToleranceCount()));
            }
            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringConversion.fromInteger((Integer)operationPreferences.failureTolerancePercentage()));
            }
            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringConversion.fromInteger((Integer)operationPreferences.maxConcurrentCount()));
            }
            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringConversion.fromInteger((Integer)operationPreferences.maxConcurrentPercentage()));
            }
        }
        if (updateStackSetRequest.administrationRoleARN() != null) {
            request.addParameter("AdministrationRoleARN", StringConversion.fromString((String)updateStackSetRequest.administrationRoleARN()));
        }
        if (updateStackSetRequest.executionRoleName() != null) {
            request.addParameter("ExecutionRoleName", StringConversion.fromString((String)updateStackSetRequest.executionRoleName()));
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)updateStackSetRequest.operationId()));
        if (updateStackSetRequest.accounts().isEmpty() && !(updateStackSetRequest.accounts() instanceof SdkAutoConstructList)) {
            request.addParameter("Accounts", "");
        } else if (!updateStackSetRequest.accounts().isEmpty() && !(updateStackSetRequest.accounts() instanceof SdkAutoConstructList)) {
            List<String> accountsList = updateStackSetRequest.accounts();
            int accountsListIndex = 1;
            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringConversion.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if (updateStackSetRequest.regions().isEmpty() && !(updateStackSetRequest.regions() instanceof SdkAutoConstructList)) {
            request.addParameter("Regions", "");
        } else if (!updateStackSetRequest.regions().isEmpty() && !(updateStackSetRequest.regions() instanceof SdkAutoConstructList)) {
            List<String> regionsList = updateStackSetRequest.regions();
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringConversion.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        return request;
    }
}

