/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.StopStackSetOperationRequest;

public class StopStackSetOperationRequestMarshaller
implements Marshaller<Request<StopStackSetOperationRequest>, StopStackSetOperationRequest> {
    public Request<StopStackSetOperationRequest> marshall(StopStackSetOperationRequest stopStackSetOperationRequest) {
        if (stopStackSetOperationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)stopStackSetOperationRequest, "CloudFormationClient");
        request.addParameter("Action", "StopStackSetOperation");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (stopStackSetOperationRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)stopStackSetOperationRequest.stackSetName()));
        }
        if (stopStackSetOperationRequest.operationId() != null) {
            request.addParameter("OperationId", StringConversion.fromString((String)stopStackSetOperationRequest.operationId()));
        }
        return request;
    }
}

