/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Stack;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.transform.OutputUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.ParameterUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.RollbackConfigurationUnmarshaller;
import software.amazon.awssdk.services.cloudformation.transform.TagUnmarshaller;

public class StackUnmarshaller
implements Unmarshaller<Stack, StaxUnmarshallerContext> {
    private static final StackUnmarshaller INSTANCE = new StackUnmarshaller();

    public Stack unmarshall(StaxUnmarshallerContext context) throws Exception {
        Stack.Builder stack;
        block29: {
            stack = Stack.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Parameter> parameters = null;
            ArrayList<String> notificationARNs = null;
            ArrayList<String> capabilities = null;
            ArrayList<Output> outputs = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    stack.parameters(parameters);
                    stack.notificationARNs(notificationARNs);
                    stack.capabilitiesWithStrings(capabilities);
                    stack.outputs(outputs);
                    stack.tags(tags);
                    break block29;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("StackId", targetDepth)) {
                        stack.stackId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StackName", targetDepth)) {
                        stack.stackName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ChangeSetId", targetDepth)) {
                        stack.changeSetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        stack.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Parameters", targetDepth)) {
                        parameters = new ArrayList<Parameter>();
                        continue;
                    }
                    if (context.testExpression("Parameters/member", targetDepth)) {
                        parameters.add(ParameterUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("CreationTime", targetDepth)) {
                        stack.creationTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DeletionTime", targetDepth)) {
                        stack.deletionTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("LastUpdatedTime", targetDepth)) {
                        stack.lastUpdatedTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RollbackConfiguration", targetDepth)) {
                        stack.rollbackConfiguration(RollbackConfigurationUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StackStatus", targetDepth)) {
                        stack.stackStatus(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("StackStatusReason", targetDepth)) {
                        stack.stackStatusReason(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("DisableRollback", targetDepth)) {
                        stack.disableRollback(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("NotificationARNs", targetDepth)) {
                        notificationARNs = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("NotificationARNs/member", targetDepth)) {
                        notificationARNs.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("TimeoutInMinutes", targetDepth)) {
                        stack.timeoutInMinutes(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Capabilities", targetDepth)) {
                        capabilities = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("Capabilities/member", targetDepth)) {
                        capabilities.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Outputs", targetDepth)) {
                        outputs = new ArrayList<Output>();
                        continue;
                    }
                    if (context.testExpression("Outputs/member", targetDepth)) {
                        outputs.add(OutputUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("RoleARN", targetDepth)) {
                        stack.roleARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (context.testExpression("Tags/member", targetDepth)) {
                        tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EnableTerminationProtection", targetDepth)) {
                        stack.enableTerminationProtection(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ParentId", targetDepth)) {
                        stack.parentId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("RootId", targetDepth)) continue;
                    stack.rootId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            stack.parameters(parameters);
            stack.notificationARNs(notificationARNs);
            stack.capabilitiesWithStrings(capabilities);
            stack.outputs(outputs);
            stack.tags(tags);
        }
        return (Stack)stack.build();
    }

    public static StackUnmarshaller getInstance() {
        return INSTANCE;
    }
}

