/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperation;
import software.amazon.awssdk.services.cloudformation.transform.StackSetOperationPreferencesUnmarshaller;

public class StackSetOperationUnmarshaller
implements Unmarshaller<StackSetOperation, StaxUnmarshallerContext> {
    private static final StackSetOperationUnmarshaller INSTANCE = new StackSetOperationUnmarshaller();

    public StackSetOperation unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StackSetOperation.Builder stackSetOperation = StackSetOperation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("OperationId", targetDepth)) {
                    stackSetOperation.operationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StackSetId", targetDepth)) {
                    stackSetOperation.stackSetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Action", targetDepth)) {
                    stackSetOperation.action(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    stackSetOperation.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OperationPreferences", targetDepth)) {
                    stackSetOperation.operationPreferences(StackSetOperationPreferencesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RetainStacks", targetDepth)) {
                    stackSetOperation.retainStacks(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AdministrationRoleARN", targetDepth)) {
                    stackSetOperation.administrationRoleARN(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ExecutionRoleName", targetDepth)) {
                    stackSetOperation.executionRoleName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CreationTimestamp", targetDepth)) {
                    stackSetOperation.creationTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EndTimestamp", targetDepth)) continue;
                stackSetOperation.endTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StackSetOperation)stackSetOperation.build();
    }

    public static StackSetOperationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

