/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ExecuteChangeSetRequest;

public class ExecuteChangeSetRequestMarshaller
implements Marshaller<Request<ExecuteChangeSetRequest>, ExecuteChangeSetRequest> {
    public Request<ExecuteChangeSetRequest> marshall(ExecuteChangeSetRequest executeChangeSetRequest) {
        if (executeChangeSetRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)executeChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "ExecuteChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (executeChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringConversion.fromString((String)executeChangeSetRequest.changeSetName()));
        }
        if (executeChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)executeChangeSetRequest.stackName()));
        }
        if (executeChangeSetRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringConversion.fromString((String)executeChangeSetRequest.clientRequestToken()));
        }
        return request;
    }
}

