/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationAction;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackSetOperationSummary
implements ToCopyableBuilder<Builder, StackSetOperationSummary> {
    private final String operationId;
    private final String action;
    private final String status;
    private final Instant creationTimestamp;
    private final Instant endTimestamp;

    private StackSetOperationSummary(BuilderImpl builder) {
        this.operationId = builder.operationId;
        this.action = builder.action;
        this.status = builder.status;
        this.creationTimestamp = builder.creationTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    public String operationId() {
        return this.operationId;
    }

    public StackSetOperationAction action() {
        return StackSetOperationAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public StackSetOperationStatus status() {
        return StackSetOperationStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationTimestamp() {
        return this.creationTimestamp;
    }

    public Instant endTimestamp() {
        return this.endTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTimestamp());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSetOperationSummary)) {
            return false;
        }
        StackSetOperationSummary other = (StackSetOperationSummary)obj;
        return Objects.equals(this.operationId(), other.operationId()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTimestamp(), other.creationTimestamp()) && Objects.equals(this.endTimestamp(), other.endTimestamp());
    }

    public String toString() {
        return ToString.builder((String)"StackSetOperationSummary").add("OperationId", (Object)this.operationId()).add("Action", (Object)this.actionAsString()).add("Status", (Object)this.statusAsString()).add("CreationTimestamp", (Object)this.creationTimestamp()).add("EndTimestamp", (Object)this.endTimestamp()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OperationId": {
                return Optional.ofNullable(clazz.cast(this.operationId()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTimestamp": {
                return Optional.ofNullable(clazz.cast(this.creationTimestamp()));
            }
            case "EndTimestamp": {
                return Optional.ofNullable(clazz.cast(this.endTimestamp()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String operationId;
        private String action;
        private String status;
        private Instant creationTimestamp;
        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSetOperationSummary model) {
            this.operationId(model.operationId);
            this.action(model.action);
            this.status(model.status);
            this.creationTimestamp(model.creationTimestamp);
            this.endTimestamp(model.endTimestamp);
        }

        public final String getOperationId() {
            return this.operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(StackSetOperationAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StackSetOperationStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationTimestamp() {
            return this.creationTimestamp;
        }

        @Override
        public final Builder creationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public final void setCreationTimestamp(Instant creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
        }

        public final Instant getEndTimestamp() {
            return this.endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        public StackSetOperationSummary build() {
            return new StackSetOperationSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSetOperationSummary> {
        public Builder operationId(String var1);

        public Builder action(String var1);

        public Builder action(StackSetOperationAction var1);

        public Builder status(String var1);

        public Builder status(StackSetOperationStatus var1);

        public Builder creationTimestamp(Instant var1);

        public Builder endTimestamp(Instant var1);
    }
}

