/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.services.cloudformation.model.RetainResourcesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteStackRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, DeleteStackRequest> {
    private final String stackName;
    private final List<String> retainResources;
    private final String roleARN;
    private final String clientRequestToken;

    private DeleteStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.retainResources = builder.retainResources;
        this.roleARN = builder.roleARN;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public String stackName() {
        return this.stackName;
    }

    public List<String> retainResources() {
        return this.retainResources;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStackRequest)) {
            return false;
        }
        DeleteStackRequest other = (DeleteStackRequest)((Object)obj);
        return Objects.equals(this.stackName(), other.stackName()) && Objects.equals(this.retainResources(), other.retainResources()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public String toString() {
        return ToString.builder((String)"DeleteStackRequest").add("StackName", (Object)this.stackName()).add("RetainResources", this.retainResources()).add("RoleARN", (Object)this.roleARN()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
            case "RetainResources": {
                return Optional.ofNullable(clazz.cast(this.retainResources()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private String stackName;
        private List<String> retainResources = DefaultSdkAutoConstructList.getInstance();
        private String roleARN;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStackRequest model) {
            super(model);
            this.stackName(model.stackName);
            this.retainResources(model.retainResources);
            this.roleARN(model.roleARN);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final Collection<String> getRetainResources() {
            return this.retainResources;
        }

        @Override
        public final Builder retainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retainResources(String ... retainResources) {
            this.retainResources(Arrays.asList(retainResources));
            return this;
        }

        public final void setRetainResources(Collection<String> retainResources) {
            this.retainResources = RetainResourcesCopier.copy(retainResources);
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteStackRequest build() {
            return new DeleteStackRequest(this);
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    CopyableBuilder<Builder, DeleteStackRequest> {
        public Builder stackName(String var1);

        public Builder retainResources(Collection<String> var1);

        public Builder retainResources(String ... var1);

        public Builder roleARN(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

