/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.ListChangeSetsRequest;

public class ListChangeSetsRequestMarshaller
implements Marshaller<Request<ListChangeSetsRequest>, ListChangeSetsRequest> {
    public Request<ListChangeSetsRequest> marshall(ListChangeSetsRequest listChangeSetsRequest) {
        if (listChangeSetsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)listChangeSetsRequest, "CloudFormationClient");
        request.addParameter("Action", "ListChangeSets");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (listChangeSetsRequest.stackName() != null) {
            request.addParameter("StackName", StringConversion.fromString((String)listChangeSetsRequest.stackName()));
        }
        if (listChangeSetsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)listChangeSetsRequest.nextToken()));
        }
        return request;
    }
}

