/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.EstimateTemplateCostRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;

public class EstimateTemplateCostRequestMarshaller
implements Marshaller<Request<EstimateTemplateCostRequest>, EstimateTemplateCostRequest> {
    public Request<EstimateTemplateCostRequest> marshall(EstimateTemplateCostRequest estimateTemplateCostRequest) {
        if (estimateTemplateCostRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)estimateTemplateCostRequest, "CloudFormationClient");
        request.addParameter("Action", "EstimateTemplateCost");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (estimateTemplateCostRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringConversion.fromString((String)estimateTemplateCostRequest.templateBody()));
        }
        if (estimateTemplateCostRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringConversion.fromString((String)estimateTemplateCostRequest.templateURL()));
        }
        if (estimateTemplateCostRequest.parameters().isEmpty() && !(estimateTemplateCostRequest.parameters() instanceof SdkAutoConstructList)) {
            request.addParameter("Parameters", "");
        } else if (!estimateTemplateCostRequest.parameters().isEmpty() && !(estimateTemplateCostRequest.parameters() instanceof SdkAutoConstructList)) {
            List<Parameter> parametersList = estimateTemplateCostRequest.parameters();
            int parametersListIndex = 1;
            for (Parameter parametersListValue : parametersList) {
                if (parametersListValue.parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringConversion.fromString((String)parametersListValue.parameterKey()));
                }
                if (parametersListValue.parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringConversion.fromString((String)parametersListValue.parameterValue()));
                }
                if (parametersListValue.usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringConversion.fromBoolean((Boolean)parametersListValue.usePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        return request;
    }
}

