/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.IdempotentUtils;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudformation.model.CreateStackInstancesRequest;
import software.amazon.awssdk.services.cloudformation.model.StackSetOperationPreferences;

public class CreateStackInstancesRequestMarshaller
implements Marshaller<Request<CreateStackInstancesRequest>, CreateStackInstancesRequest> {
    public Request<CreateStackInstancesRequest> marshall(CreateStackInstancesRequest createStackInstancesRequest) {
        if (createStackInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createStackInstancesRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createStackInstancesRequest.stackSetName() != null) {
            request.addParameter("StackSetName", StringConversion.fromString((String)createStackInstancesRequest.stackSetName()));
        }
        if (createStackInstancesRequest.accounts().isEmpty() && !(createStackInstancesRequest.accounts() instanceof SdkAutoConstructList)) {
            request.addParameter("Accounts", "");
        } else if (!createStackInstancesRequest.accounts().isEmpty() && !(createStackInstancesRequest.accounts() instanceof SdkAutoConstructList)) {
            List<String> accountsList = createStackInstancesRequest.accounts();
            int accountsListIndex = 1;
            for (String accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringConversion.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if (createStackInstancesRequest.regions().isEmpty() && !(createStackInstancesRequest.regions() instanceof SdkAutoConstructList)) {
            request.addParameter("Regions", "");
        } else if (!createStackInstancesRequest.regions().isEmpty() && !(createStackInstancesRequest.regions() instanceof SdkAutoConstructList)) {
            List<String> regionsList = createStackInstancesRequest.regions();
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringConversion.fromString((String)regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        StackSetOperationPreferences operationPreferences = createStackInstancesRequest.operationPreferences();
        if (operationPreferences != null) {
            if (operationPreferences.regionOrder().isEmpty() && !(operationPreferences.regionOrder() instanceof SdkAutoConstructList)) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            } else if (!operationPreferences.regionOrder().isEmpty() && !(operationPreferences.regionOrder() instanceof SdkAutoConstructList)) {
                List<String> regionOrderList = operationPreferences.regionOrder();
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringConversion.fromString((String)regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.failureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringConversion.fromInteger((Integer)operationPreferences.failureToleranceCount()));
            }
            if (operationPreferences.failureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringConversion.fromInteger((Integer)operationPreferences.failureTolerancePercentage()));
            }
            if (operationPreferences.maxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringConversion.fromInteger((Integer)operationPreferences.maxConcurrentCount()));
            }
            if (operationPreferences.maxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringConversion.fromInteger((Integer)operationPreferences.maxConcurrentPercentage()));
            }
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString((String)createStackInstancesRequest.operationId()));
        return request;
    }
}

