/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudformation.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StackResourceSummary
implements ToCopyableBuilder<Builder, StackResourceSummary> {
    private final String logicalResourceId;
    private final String physicalResourceId;
    private final String resourceType;
    private final Instant lastUpdatedTimestamp;
    private final String resourceStatus;
    private final String resourceStatusReason;

    private StackResourceSummary(BuilderImpl builder) {
        this.logicalResourceId = builder.logicalResourceId;
        this.physicalResourceId = builder.physicalResourceId;
        this.resourceType = builder.resourceType;
        this.lastUpdatedTimestamp = builder.lastUpdatedTimestamp;
        this.resourceStatus = builder.resourceStatus;
        this.resourceStatusReason = builder.resourceStatusReason;
    }

    public String logicalResourceId() {
        return this.logicalResourceId;
    }

    public String physicalResourceId() {
        return this.physicalResourceId;
    }

    public String resourceType() {
        return this.resourceType;
    }

    public Instant lastUpdatedTimestamp() {
        return this.lastUpdatedTimestamp;
    }

    public ResourceStatus resourceStatus() {
        return ResourceStatus.fromValue(this.resourceStatus);
    }

    public String resourceStatusAsString() {
        return this.resourceStatus;
    }

    public String resourceStatusReason() {
        return this.resourceStatusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceStatusReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackResourceSummary)) {
            return false;
        }
        StackResourceSummary other = (StackResourceSummary)obj;
        return Objects.equals(this.logicalResourceId(), other.logicalResourceId()) && Objects.equals(this.physicalResourceId(), other.physicalResourceId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.lastUpdatedTimestamp(), other.lastUpdatedTimestamp()) && Objects.equals(this.resourceStatusAsString(), other.resourceStatusAsString()) && Objects.equals(this.resourceStatusReason(), other.resourceStatusReason());
    }

    public String toString() {
        return ToString.builder((String)"StackResourceSummary").add("LogicalResourceId", (Object)this.logicalResourceId()).add("PhysicalResourceId", (Object)this.physicalResourceId()).add("ResourceType", (Object)this.resourceType()).add("LastUpdatedTimestamp", (Object)this.lastUpdatedTimestamp()).add("ResourceStatus", (Object)this.resourceStatusAsString()).add("ResourceStatusReason", (Object)this.resourceStatusReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.logicalResourceId()));
            }
            case "PhysicalResourceId": {
                return Optional.ofNullable(clazz.cast(this.physicalResourceId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "LastUpdatedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimestamp()));
            }
            case "ResourceStatus": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusAsString()));
            }
            case "ResourceStatusReason": {
                return Optional.ofNullable(clazz.cast(this.resourceStatusReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalResourceId;
        private String physicalResourceId;
        private String resourceType;
        private Instant lastUpdatedTimestamp;
        private String resourceStatus;
        private String resourceStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(StackResourceSummary model) {
            this.logicalResourceId(model.logicalResourceId);
            this.physicalResourceId(model.physicalResourceId);
            this.resourceType(model.resourceType);
            this.lastUpdatedTimestamp(model.lastUpdatedTimestamp);
            this.resourceStatus(model.resourceStatus);
            this.resourceStatusReason(model.resourceStatusReason);
        }

        public final String getLogicalResourceId() {
            return this.logicalResourceId;
        }

        @Override
        public final Builder logicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
            return this;
        }

        public final void setLogicalResourceId(String logicalResourceId) {
            this.logicalResourceId = logicalResourceId;
        }

        public final String getPhysicalResourceId() {
            return this.physicalResourceId;
        }

        @Override
        public final Builder physicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
            return this;
        }

        public final void setPhysicalResourceId(String physicalResourceId) {
            this.physicalResourceId = physicalResourceId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Instant getLastUpdatedTimestamp() {
            return this.lastUpdatedTimestamp;
        }

        @Override
        public final Builder lastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
            return this;
        }

        public final void setLastUpdatedTimestamp(Instant lastUpdatedTimestamp) {
            this.lastUpdatedTimestamp = lastUpdatedTimestamp;
        }

        public final String getResourceStatus() {
            return this.resourceStatus;
        }

        @Override
        public final Builder resourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
            return this;
        }

        @Override
        public final Builder resourceStatus(ResourceStatus resourceStatus) {
            this.resourceStatus(resourceStatus.toString());
            return this;
        }

        public final void setResourceStatus(String resourceStatus) {
            this.resourceStatus = resourceStatus;
        }

        public final String getResourceStatusReason() {
            return this.resourceStatusReason;
        }

        @Override
        public final Builder resourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
            return this;
        }

        public final void setResourceStatusReason(String resourceStatusReason) {
            this.resourceStatusReason = resourceStatusReason;
        }

        public StackResourceSummary build() {
            return new StackResourceSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackResourceSummary> {
        public Builder logicalResourceId(String var1);

        public Builder physicalResourceId(String var1);

        public Builder resourceType(String var1);

        public Builder lastUpdatedTimestamp(Instant var1);

        public Builder resourceStatus(String var1);

        public Builder resourceStatus(ResourceStatus var1);

        public Builder resourceStatusReason(String var1);
    }
}

