/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetSummary;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChangeSetsResponse
extends CloudFormationResponse
implements ToCopyableBuilder<Builder, ListChangeSetsResponse> {
    private final List<ChangeSetSummary> summaries;
    private final String nextToken;

    private ListChangeSetsResponse(BuilderImpl builder) {
        super(builder);
        this.summaries = builder.summaries;
        this.nextToken = builder.nextToken;
    }

    public List<ChangeSetSummary> summaries() {
        return this.summaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.summaries());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChangeSetsResponse)) {
            return false;
        }
        ListChangeSetsResponse other = (ListChangeSetsResponse)((Object)obj);
        return Objects.equals(this.summaries(), other.summaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListChangeSetsResponse").add("Summaries", this.summaries()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Summaries": {
                return Optional.ofNullable(clazz.cast(this.summaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudFormationResponse.BuilderImpl
    implements Builder {
        private List<ChangeSetSummary> summaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChangeSetsResponse model) {
            super(model);
            this.summaries(model.summaries);
            this.nextToken(model.nextToken);
        }

        public final Collection<ChangeSetSummary.Builder> getSummaries() {
            return this.summaries != null ? (Collection)this.summaries.stream().map(ChangeSetSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder summaries(Collection<ChangeSetSummary> summaries) {
            this.summaries = ChangeSetSummariesCopier.copy(summaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(ChangeSetSummary ... summaries) {
            this.summaries(Arrays.asList(summaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder summaries(Consumer<ChangeSetSummary.Builder> ... summaries) {
            this.summaries(Stream.of(summaries).map(c -> (ChangeSetSummary)((ChangeSetSummary.Builder)ChangeSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSummaries(Collection<ChangeSetSummary.BuilderImpl> summaries) {
            this.summaries = ChangeSetSummariesCopier.copyFromBuilder(summaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListChangeSetsResponse build() {
            return new ListChangeSetsResponse(this);
        }
    }

    public static interface Builder
    extends CloudFormationResponse.Builder,
    CopyableBuilder<Builder, ListChangeSetsResponse> {
        public Builder summaries(Collection<ChangeSetSummary> var1);

        public Builder summaries(ChangeSetSummary ... var1);

        public Builder summaries(Consumer<ChangeSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

