/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.DeleteStackRequest;
import software.amazon.awssdk.util.StringUtils;

public class DeleteStackRequestMarshaller
implements Marshaller<Request<DeleteStackRequest>, DeleteStackRequest> {
    public Request<DeleteStackRequest> marshall(DeleteStackRequest deleteStackRequest) {
        SdkInternalList retainResourcesList;
        if (deleteStackRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteStackRequest, "CloudFormationClient");
        request.addParameter("Action", "DeleteStack");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)deleteStackRequest.stackName()));
        }
        if ((retainResourcesList = (SdkInternalList)deleteStackRequest.retainResources()).isEmpty() && !retainResourcesList.isAutoConstruct()) {
            request.addParameter("RetainResources", "");
        }
        if (!retainResourcesList.isEmpty() || !retainResourcesList.isAutoConstruct()) {
            int retainResourcesListIndex = 1;
            for (String retainResourcesListValue : retainResourcesList) {
                if (retainResourcesListValue != null) {
                    request.addParameter("RetainResources.member." + retainResourcesListIndex, StringUtils.fromString((String)retainResourcesListValue));
                }
                ++retainResourcesListIndex;
            }
        }
        if (deleteStackRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)deleteStackRequest.roleARN()));
        }
        if (deleteStackRequest.clientRequestToken() != null) {
            request.addParameter("ClientRequestToken", StringUtils.fromString((String)deleteStackRequest.clientRequestToken()));
        }
        return request;
    }
}

