/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.cloudformation.model.CreateChangeSetRequest;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.util.StringUtils;

public class CreateChangeSetRequestMarshaller
implements Marshaller<Request<CreateChangeSetRequest>, CreateChangeSetRequest> {
    public Request<CreateChangeSetRequest> marshall(CreateChangeSetRequest createChangeSetRequest) {
        SdkInternalList tagsList;
        SdkInternalList notificationARNsList;
        SdkInternalList resourceTypesList;
        SdkInternalList capabilitiesList;
        SdkInternalList parametersList;
        if (createChangeSetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createChangeSetRequest, "CloudFormationClient");
        request.addParameter("Action", "CreateChangeSet");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createChangeSetRequest.stackName() != null) {
            request.addParameter("StackName", StringUtils.fromString((String)createChangeSetRequest.stackName()));
        }
        if (createChangeSetRequest.templateBody() != null) {
            request.addParameter("TemplateBody", StringUtils.fromString((String)createChangeSetRequest.templateBody()));
        }
        if (createChangeSetRequest.templateURL() != null) {
            request.addParameter("TemplateURL", StringUtils.fromString((String)createChangeSetRequest.templateURL()));
        }
        if (createChangeSetRequest.usePreviousTemplate() != null) {
            request.addParameter("UsePreviousTemplate", StringUtils.fromBoolean((Boolean)createChangeSetRequest.usePreviousTemplate()));
        }
        if ((parametersList = (SdkInternalList)createChangeSetRequest.parameters()).isEmpty() && !parametersList.isAutoConstruct()) {
            request.addParameter("Parameters", "");
        }
        if (!parametersList.isEmpty() || !parametersList.isAutoConstruct()) {
            int parametersListIndex = 1;
            for (Object parametersListValue : parametersList) {
                if (((Parameter)parametersListValue).parameterKey() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterKey", StringUtils.fromString((String)((Parameter)parametersListValue).parameterKey()));
                }
                if (((Parameter)parametersListValue).parameterValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)((Parameter)parametersListValue).parameterValue()));
                }
                if (((Parameter)parametersListValue).usePreviousValue() != null) {
                    request.addParameter("Parameters.member." + parametersListIndex + ".UsePreviousValue", StringUtils.fromBoolean((Boolean)((Parameter)parametersListValue).usePreviousValue()));
                }
                ++parametersListIndex;
            }
        }
        if ((capabilitiesList = (SdkInternalList)createChangeSetRequest.capabilities()).isEmpty() && !capabilitiesList.isAutoConstruct()) {
            request.addParameter("Capabilities", "");
        }
        if (!capabilitiesList.isEmpty() || !capabilitiesList.isAutoConstruct()) {
            int capabilitiesListIndex = 1;
            for (Object capabilitiesListValue : capabilitiesList) {
                if (capabilitiesListValue != null) {
                    request.addParameter("Capabilities.member." + capabilitiesListIndex, StringUtils.fromString((String)capabilitiesListValue));
                }
                ++capabilitiesListIndex;
            }
        }
        if ((resourceTypesList = (SdkInternalList)createChangeSetRequest.resourceTypes()).isEmpty() && !resourceTypesList.isAutoConstruct()) {
            request.addParameter("ResourceTypes", "");
        }
        if (!resourceTypesList.isEmpty() || !resourceTypesList.isAutoConstruct()) {
            int resourceTypesListIndex = 1;
            for (Object resourceTypesListValue : resourceTypesList) {
                if (resourceTypesListValue != null) {
                    request.addParameter("ResourceTypes.member." + resourceTypesListIndex, StringUtils.fromString((String)resourceTypesListValue));
                }
                ++resourceTypesListIndex;
            }
        }
        if (createChangeSetRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringUtils.fromString((String)createChangeSetRequest.roleARN()));
        }
        if ((notificationARNsList = (SdkInternalList)createChangeSetRequest.notificationARNs()).isEmpty() && !notificationARNsList.isAutoConstruct()) {
            request.addParameter("NotificationARNs", "");
        }
        if (!notificationARNsList.isEmpty() || !notificationARNsList.isAutoConstruct()) {
            int notificationARNsListIndex = 1;
            for (String notificationARNsListValue : notificationARNsList) {
                if (notificationARNsListValue != null) {
                    request.addParameter("NotificationARNs.member." + notificationARNsListIndex, StringUtils.fromString((String)notificationARNsListValue));
                }
                ++notificationARNsListIndex;
            }
        }
        if ((tagsList = (SdkInternalList)createChangeSetRequest.tags()).isEmpty() && !tagsList.isAutoConstruct()) {
            request.addParameter("Tags", "");
        }
        if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.value()));
                }
                ++tagsListIndex;
            }
        }
        if (createChangeSetRequest.changeSetName() != null) {
            request.addParameter("ChangeSetName", StringUtils.fromString((String)createChangeSetRequest.changeSetName()));
        }
        if (createChangeSetRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)createChangeSetRequest.clientToken()));
        }
        if (createChangeSetRequest.description() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createChangeSetRequest.description()));
        }
        if (createChangeSetRequest.changeSetType() != null) {
            request.addParameter("ChangeSetType", StringUtils.fromString((String)createChangeSetRequest.changeSetType()));
        }
        return request;
    }
}

