/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Output;
import software.amazon.awssdk.services.cloudformation.model.OutputsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.StackStatus;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Stack
implements ToCopyableBuilder<Builder, Stack> {
    private final String stackId;
    private final String stackName;
    private final String changeSetId;
    private final String description;
    private final List<Parameter> parameters;
    private final Date creationTime;
    private final Date lastUpdatedTime;
    private final String stackStatus;
    private final String stackStatusReason;
    private final Boolean disableRollback;
    private final List<String> notificationARNs;
    private final Integer timeoutInMinutes;
    private final List<String> capabilities;
    private final List<Output> outputs;
    private final String roleARN;
    private final List<Tag> tags;

    private Stack(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.stackName = builder.stackName;
        this.changeSetId = builder.changeSetId;
        this.description = builder.description;
        this.parameters = builder.parameters;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.stackStatus = builder.stackStatus;
        this.stackStatusReason = builder.stackStatusReason;
        this.disableRollback = builder.disableRollback;
        this.notificationARNs = builder.notificationARNs;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.capabilities = builder.capabilities;
        this.outputs = builder.outputs;
        this.roleARN = builder.roleARN;
        this.tags = builder.tags;
    }

    public String stackId() {
        return this.stackId;
    }

    public String stackName() {
        return this.stackName;
    }

    public String changeSetId() {
        return this.changeSetId;
    }

    public String description() {
        return this.description;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Date creationTime() {
        return this.creationTime;
    }

    public Date lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public String stackStatus() {
        return this.stackStatus;
    }

    public String stackStatusReason() {
        return this.stackStatusReason;
    }

    public Boolean disableRollback() {
        return this.disableRollback;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public List<Output> outputs() {
        return this.outputs;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.changeSetId() == null ? 0 : this.changeSetId().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.creationTime() == null ? 0 : this.creationTime().hashCode());
        hashCode = 31 * hashCode + (this.lastUpdatedTime() == null ? 0 : this.lastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.stackStatus() == null ? 0 : this.stackStatus().hashCode());
        hashCode = 31 * hashCode + (this.stackStatusReason() == null ? 0 : this.stackStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.disableRollback() == null ? 0 : this.disableRollback().hashCode());
        hashCode = 31 * hashCode + (this.notificationARNs() == null ? 0 : this.notificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.timeoutInMinutes() == null ? 0 : this.timeoutInMinutes().hashCode());
        hashCode = 31 * hashCode + (this.capabilities() == null ? 0 : this.capabilities().hashCode());
        hashCode = 31 * hashCode + (this.outputs() == null ? 0 : this.outputs().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stack)) {
            return false;
        }
        Stack other = (Stack)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.changeSetId() == null ^ this.changeSetId() == null) {
            return false;
        }
        if (other.changeSetId() != null && !other.changeSetId().equals(this.changeSetId())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.creationTime() == null ^ this.creationTime() == null) {
            return false;
        }
        if (other.creationTime() != null && !other.creationTime().equals(this.creationTime())) {
            return false;
        }
        if (other.lastUpdatedTime() == null ^ this.lastUpdatedTime() == null) {
            return false;
        }
        if (other.lastUpdatedTime() != null && !other.lastUpdatedTime().equals(this.lastUpdatedTime())) {
            return false;
        }
        if (other.stackStatus() == null ^ this.stackStatus() == null) {
            return false;
        }
        if (other.stackStatus() != null && !other.stackStatus().equals(this.stackStatus())) {
            return false;
        }
        if (other.stackStatusReason() == null ^ this.stackStatusReason() == null) {
            return false;
        }
        if (other.stackStatusReason() != null && !other.stackStatusReason().equals(this.stackStatusReason())) {
            return false;
        }
        if (other.disableRollback() == null ^ this.disableRollback() == null) {
            return false;
        }
        if (other.disableRollback() != null && !other.disableRollback().equals(this.disableRollback())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.timeoutInMinutes() == null ^ this.timeoutInMinutes() == null) {
            return false;
        }
        if (other.timeoutInMinutes() != null && !other.timeoutInMinutes().equals(this.timeoutInMinutes())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.outputs() == null ^ this.outputs() == null) {
            return false;
        }
        if (other.outputs() != null && !other.outputs().equals(this.outputs())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.changeSetId() != null) {
            sb.append("ChangeSetId: ").append(this.changeSetId()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.creationTime() != null) {
            sb.append("CreationTime: ").append(this.creationTime()).append(",");
        }
        if (this.lastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.lastUpdatedTime()).append(",");
        }
        if (this.stackStatus() != null) {
            sb.append("StackStatus: ").append(this.stackStatus()).append(",");
        }
        if (this.stackStatusReason() != null) {
            sb.append("StackStatusReason: ").append(this.stackStatusReason()).append(",");
        }
        if (this.disableRollback() != null) {
            sb.append("DisableRollback: ").append(this.disableRollback()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.timeoutInMinutes() != null) {
            sb.append("TimeoutInMinutes: ").append(this.timeoutInMinutes()).append(",");
        }
        if (this.capabilities() != null) {
            sb.append("Capabilities: ").append(this.capabilities()).append(",");
        }
        if (this.outputs() != null) {
            sb.append("Outputs: ").append(this.outputs()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String stackName;
        private String changeSetId;
        private String description;
        private List<Parameter> parameters = new SdkInternalList();
        private Date creationTime;
        private Date lastUpdatedTime;
        private String stackStatus;
        private String stackStatusReason;
        private Boolean disableRollback;
        private List<String> notificationARNs = new SdkInternalList();
        private Integer timeoutInMinutes;
        private List<String> capabilities = new SdkInternalList();
        private List<Output> outputs = new SdkInternalList();
        private String roleARN;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(Stack model) {
            this.setStackId(model.stackId);
            this.setStackName(model.stackName);
            this.setChangeSetId(model.changeSetId);
            this.setDescription(model.description);
            this.setParameters(model.parameters);
            this.setCreationTime(model.creationTime);
            this.setLastUpdatedTime(model.lastUpdatedTime);
            this.setStackStatus(model.stackStatus);
            this.setStackStatusReason(model.stackStatusReason);
            this.setDisableRollback(model.disableRollback);
            this.setNotificationARNs(model.notificationARNs);
            this.setTimeoutInMinutes(model.timeoutInMinutes);
            this.setCapabilities(model.capabilities);
            this.setOutputs(model.outputs);
            this.setRoleARN(model.roleARN);
            this.setTags(model.tags);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getChangeSetId() {
            return this.changeSetId;
        }

        @Override
        public final Builder changeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
            return this;
        }

        public final void setChangeSetId(String changeSetId) {
            this.changeSetId = changeSetId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public final Date getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
            return this;
        }

        public final void setCreationTime(Date creationTime) {
            this.creationTime = StandardMemberCopier.copy((Date)creationTime);
        }

        public final Date getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = StandardMemberCopier.copy((Date)lastUpdatedTime);
            return this;
        }

        public final void setLastUpdatedTime(Date lastUpdatedTime) {
            this.lastUpdatedTime = StandardMemberCopier.copy((Date)lastUpdatedTime);
        }

        public final String getStackStatus() {
            return this.stackStatus;
        }

        @Override
        public final Builder stackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
            return this;
        }

        @Override
        public final Builder stackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
            return this;
        }

        public final void setStackStatus(String stackStatus) {
            this.stackStatus = stackStatus;
        }

        public final void setStackStatus(StackStatus stackStatus) {
            this.stackStatus(stackStatus.toString());
        }

        public final String getStackStatusReason() {
            return this.stackStatusReason;
        }

        @Override
        public final Builder stackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
            return this;
        }

        public final void setStackStatusReason(String stackStatusReason) {
            this.stackStatusReason = stackStatusReason;
        }

        public final Boolean getDisableRollback() {
            return this.disableRollback;
        }

        @Override
        public final Builder disableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
            return this;
        }

        public final void setDisableRollback(Boolean disableRollback) {
            this.disableRollback = disableRollback;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            if (this.notificationARNs == null) {
                this.notificationARNs = new SdkInternalList(notificationARNs.length);
            }
            for (String e : notificationARNs) {
                this.notificationARNs.add(e);
            }
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @SafeVarargs
        public final void setNotificationARNs(String ... notificationARNs) {
            if (this.notificationARNs == null) {
                this.notificationARNs = new SdkInternalList(notificationARNs.length);
            }
            for (String e : notificationARNs) {
                this.notificationARNs.add(e);
            }
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (String e : capabilities) {
                this.capabilities.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (Capability ele : capabilities) {
                this.capabilities.add(ele.toString());
            }
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @SafeVarargs
        public final void setCapabilities(String ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (String e : capabilities) {
                this.capabilities.add(e);
            }
        }

        @SafeVarargs
        public final void setCapabilities(Capability ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (Capability ele : capabilities) {
                this.capabilities.add(ele.toString());
            }
        }

        public final Collection<Output> getOutputs() {
            return this.outputs;
        }

        @Override
        public final Builder outputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Output ... outputs) {
            if (this.outputs == null) {
                this.outputs = new SdkInternalList(outputs.length);
            }
            for (Output e : outputs) {
                this.outputs.add(e);
            }
            return this;
        }

        public final void setOutputs(Collection<Output> outputs) {
            this.outputs = OutputsCopier.copy(outputs);
        }

        @SafeVarargs
        public final void setOutputs(Output ... outputs) {
            if (this.outputs == null) {
                this.outputs = new SdkInternalList(outputs.length);
            }
            for (Output e : outputs) {
                this.outputs.add(e);
            }
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public Stack build() {
            return new Stack(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Stack> {
        public Builder stackId(String var1);

        public Builder stackName(String var1);

        public Builder changeSetId(String var1);

        public Builder description(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder creationTime(Date var1);

        public Builder lastUpdatedTime(Date var1);

        public Builder stackStatus(String var1);

        public Builder stackStatus(StackStatus var1);

        public Builder stackStatusReason(String var1);

        public Builder disableRollback(Boolean var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilities(Capability ... var1);

        public Builder outputs(Collection<Output> var1);

        public Builder outputs(Output ... var1);

        public Builder roleARN(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

