/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudformation.model.StackSummariesCopier;
import software.amazon.awssdk.services.cloudformation.model.StackSummary;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListStacksResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListStacksResponse> {
    private final List<StackSummary> stackSummaries;
    private final String nextToken;

    private ListStacksResponse(BuilderImpl builder) {
        this.stackSummaries = builder.stackSummaries;
        this.nextToken = builder.nextToken;
    }

    public List<StackSummary> stackSummaries() {
        return this.stackSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackSummaries() == null ? 0 : this.stackSummaries().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStacksResponse)) {
            return false;
        }
        ListStacksResponse other = (ListStacksResponse)((Object)obj);
        if (other.stackSummaries() == null ^ this.stackSummaries() == null) {
            return false;
        }
        if (other.stackSummaries() != null && !other.stackSummaries().equals(this.stackSummaries())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackSummaries() != null) {
            sb.append("StackSummaries: ").append(this.stackSummaries()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StackSummary> stackSummaries = new SdkInternalList();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStacksResponse model) {
            this.setStackSummaries(model.stackSummaries);
            this.setNextToken(model.nextToken);
        }

        public final Collection<StackSummary> getStackSummaries() {
            return this.stackSummaries;
        }

        @Override
        public final Builder stackSummaries(Collection<StackSummary> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copy(stackSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackSummaries(StackSummary ... stackSummaries) {
            if (this.stackSummaries == null) {
                this.stackSummaries = new SdkInternalList(stackSummaries.length);
            }
            for (StackSummary e : stackSummaries) {
                this.stackSummaries.add(e);
            }
            return this;
        }

        public final void setStackSummaries(Collection<StackSummary> stackSummaries) {
            this.stackSummaries = StackSummariesCopier.copy(stackSummaries);
        }

        @SafeVarargs
        public final void setStackSummaries(StackSummary ... stackSummaries) {
            if (this.stackSummaries == null) {
                this.stackSummaries = new SdkInternalList(stackSummaries.length);
            }
            for (StackSummary e : stackSummaries) {
                this.stackSummaries.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListStacksResponse build() {
            return new ListStacksResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListStacksResponse> {
        public Builder stackSummaries(Collection<StackSummary> var1);

        public Builder stackSummaries(StackSummary ... var1);

        public Builder nextToken(String var1);
    }
}

