/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudformation.model.StackResource;
import software.amazon.awssdk.services.cloudformation.model.StackResourcesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeStackResourcesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeStackResourcesResponse> {
    private final List<StackResource> stackResources;

    private DescribeStackResourcesResponse(BuilderImpl builder) {
        this.stackResources = builder.stackResources;
    }

    public List<StackResource> stackResources() {
        return this.stackResources;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackResources() == null ? 0 : this.stackResources().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStackResourcesResponse)) {
            return false;
        }
        DescribeStackResourcesResponse other = (DescribeStackResourcesResponse)((Object)obj);
        if (other.stackResources() == null ^ this.stackResources() == null) {
            return false;
        }
        return other.stackResources() == null || other.stackResources().equals(this.stackResources());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackResources() != null) {
            sb.append("StackResources: ").append(this.stackResources()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<StackResource> stackResources = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStackResourcesResponse model) {
            this.setStackResources(model.stackResources);
        }

        public final Collection<StackResource> getStackResources() {
            return this.stackResources;
        }

        @Override
        public final Builder stackResources(Collection<StackResource> stackResources) {
            this.stackResources = StackResourcesCopier.copy(stackResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stackResources(StackResource ... stackResources) {
            if (this.stackResources == null) {
                this.stackResources = new SdkInternalList(stackResources.length);
            }
            for (StackResource e : stackResources) {
                this.stackResources.add(e);
            }
            return this;
        }

        public final void setStackResources(Collection<StackResource> stackResources) {
            this.stackResources = StackResourcesCopier.copy(stackResources);
        }

        @SafeVarargs
        public final void setStackResources(StackResource ... stackResources) {
            if (this.stackResources == null) {
                this.stackResources = new SdkInternalList(stackResources.length);
            }
            for (StackResource e : stackResources) {
                this.stackResources.add(e);
            }
        }

        public DescribeStackResourcesResponse build() {
            return new DescribeStackResourcesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeStackResourcesResponse> {
        public Builder stackResources(Collection<StackResource> var1);

        public Builder stackResources(StackResource ... var1);
    }
}

