/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.cloudformation.model.CapabilitiesCopier;
import software.amazon.awssdk.services.cloudformation.model.Capability;
import software.amazon.awssdk.services.cloudformation.model.ChangeSetType;
import software.amazon.awssdk.services.cloudformation.model.NotificationARNsCopier;
import software.amazon.awssdk.services.cloudformation.model.Parameter;
import software.amazon.awssdk.services.cloudformation.model.ParametersCopier;
import software.amazon.awssdk.services.cloudformation.model.ResourceTypesCopier;
import software.amazon.awssdk.services.cloudformation.model.Tag;
import software.amazon.awssdk.services.cloudformation.model.TagsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateChangeSetRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateChangeSetRequest> {
    private final String stackName;
    private final String templateBody;
    private final String templateURL;
    private final Boolean usePreviousTemplate;
    private final List<Parameter> parameters;
    private final List<String> capabilities;
    private final List<String> resourceTypes;
    private final String roleARN;
    private final List<String> notificationARNs;
    private final List<Tag> tags;
    private final String changeSetName;
    private final String clientToken;
    private final String description;
    private final String changeSetType;

    private CreateChangeSetRequest(BuilderImpl builder) {
        this.stackName = builder.stackName;
        this.templateBody = builder.templateBody;
        this.templateURL = builder.templateURL;
        this.usePreviousTemplate = builder.usePreviousTemplate;
        this.parameters = builder.parameters;
        this.capabilities = builder.capabilities;
        this.resourceTypes = builder.resourceTypes;
        this.roleARN = builder.roleARN;
        this.notificationARNs = builder.notificationARNs;
        this.tags = builder.tags;
        this.changeSetName = builder.changeSetName;
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.changeSetType = builder.changeSetType;
    }

    public String stackName() {
        return this.stackName;
    }

    public String templateBody() {
        return this.templateBody;
    }

    public String templateURL() {
        return this.templateURL;
    }

    public Boolean usePreviousTemplate() {
        return this.usePreviousTemplate;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public List<String> capabilities() {
        return this.capabilities;
    }

    public List<String> resourceTypes() {
        return this.resourceTypes;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public List<String> notificationARNs() {
        return this.notificationARNs;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String changeSetName() {
        return this.changeSetName;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String description() {
        return this.description;
    }

    public String changeSetType() {
        return this.changeSetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackName() == null ? 0 : this.stackName().hashCode());
        hashCode = 31 * hashCode + (this.templateBody() == null ? 0 : this.templateBody().hashCode());
        hashCode = 31 * hashCode + (this.templateURL() == null ? 0 : this.templateURL().hashCode());
        hashCode = 31 * hashCode + (this.usePreviousTemplate() == null ? 0 : this.usePreviousTemplate().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        hashCode = 31 * hashCode + (this.capabilities() == null ? 0 : this.capabilities().hashCode());
        hashCode = 31 * hashCode + (this.resourceTypes() == null ? 0 : this.resourceTypes().hashCode());
        hashCode = 31 * hashCode + (this.roleARN() == null ? 0 : this.roleARN().hashCode());
        hashCode = 31 * hashCode + (this.notificationARNs() == null ? 0 : this.notificationARNs().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.changeSetName() == null ? 0 : this.changeSetName().hashCode());
        hashCode = 31 * hashCode + (this.clientToken() == null ? 0 : this.clientToken().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.changeSetType() == null ? 0 : this.changeSetType().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChangeSetRequest)) {
            return false;
        }
        CreateChangeSetRequest other = (CreateChangeSetRequest)((Object)obj);
        if (other.stackName() == null ^ this.stackName() == null) {
            return false;
        }
        if (other.stackName() != null && !other.stackName().equals(this.stackName())) {
            return false;
        }
        if (other.templateBody() == null ^ this.templateBody() == null) {
            return false;
        }
        if (other.templateBody() != null && !other.templateBody().equals(this.templateBody())) {
            return false;
        }
        if (other.templateURL() == null ^ this.templateURL() == null) {
            return false;
        }
        if (other.templateURL() != null && !other.templateURL().equals(this.templateURL())) {
            return false;
        }
        if (other.usePreviousTemplate() == null ^ this.usePreviousTemplate() == null) {
            return false;
        }
        if (other.usePreviousTemplate() != null && !other.usePreviousTemplate().equals(this.usePreviousTemplate())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        if (other.parameters() != null && !other.parameters().equals(this.parameters())) {
            return false;
        }
        if (other.capabilities() == null ^ this.capabilities() == null) {
            return false;
        }
        if (other.capabilities() != null && !other.capabilities().equals(this.capabilities())) {
            return false;
        }
        if (other.resourceTypes() == null ^ this.resourceTypes() == null) {
            return false;
        }
        if (other.resourceTypes() != null && !other.resourceTypes().equals(this.resourceTypes())) {
            return false;
        }
        if (other.roleARN() == null ^ this.roleARN() == null) {
            return false;
        }
        if (other.roleARN() != null && !other.roleARN().equals(this.roleARN())) {
            return false;
        }
        if (other.notificationARNs() == null ^ this.notificationARNs() == null) {
            return false;
        }
        if (other.notificationARNs() != null && !other.notificationARNs().equals(this.notificationARNs())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.changeSetName() == null ^ this.changeSetName() == null) {
            return false;
        }
        if (other.changeSetName() != null && !other.changeSetName().equals(this.changeSetName())) {
            return false;
        }
        if (other.clientToken() == null ^ this.clientToken() == null) {
            return false;
        }
        if (other.clientToken() != null && !other.clientToken().equals(this.clientToken())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.changeSetType() == null ^ this.changeSetType() == null) {
            return false;
        }
        return other.changeSetType() == null || other.changeSetType().equals(this.changeSetType());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackName() != null) {
            sb.append("StackName: ").append(this.stackName()).append(",");
        }
        if (this.templateBody() != null) {
            sb.append("TemplateBody: ").append(this.templateBody()).append(",");
        }
        if (this.templateURL() != null) {
            sb.append("TemplateURL: ").append(this.templateURL()).append(",");
        }
        if (this.usePreviousTemplate() != null) {
            sb.append("UsePreviousTemplate: ").append(this.usePreviousTemplate()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (this.capabilities() != null) {
            sb.append("Capabilities: ").append(this.capabilities()).append(",");
        }
        if (this.resourceTypes() != null) {
            sb.append("ResourceTypes: ").append(this.resourceTypes()).append(",");
        }
        if (this.roleARN() != null) {
            sb.append("RoleARN: ").append(this.roleARN()).append(",");
        }
        if (this.notificationARNs() != null) {
            sb.append("NotificationARNs: ").append(this.notificationARNs()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.changeSetName() != null) {
            sb.append("ChangeSetName: ").append(this.changeSetName()).append(",");
        }
        if (this.clientToken() != null) {
            sb.append("ClientToken: ").append(this.clientToken()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.changeSetType() != null) {
            sb.append("ChangeSetType: ").append(this.changeSetType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackName;
        private String templateBody;
        private String templateURL;
        private Boolean usePreviousTemplate;
        private List<Parameter> parameters = new SdkInternalList();
        private List<String> capabilities = new SdkInternalList();
        private List<String> resourceTypes = new SdkInternalList();
        private String roleARN;
        private List<String> notificationARNs = new SdkInternalList();
        private List<Tag> tags = new SdkInternalList();
        private String changeSetName;
        private String clientToken;
        private String description;
        private String changeSetType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateChangeSetRequest model) {
            this.setStackName(model.stackName);
            this.setTemplateBody(model.templateBody);
            this.setTemplateURL(model.templateURL);
            this.setUsePreviousTemplate(model.usePreviousTemplate);
            this.setParameters(model.parameters);
            this.setCapabilities(model.capabilities);
            this.setResourceTypes(model.resourceTypes);
            this.setRoleARN(model.roleARN);
            this.setNotificationARNs(model.notificationARNs);
            this.setTags(model.tags);
            this.setChangeSetName(model.changeSetName);
            this.setClientToken(model.clientToken);
            this.setDescription(model.description);
            this.setChangeSetType(model.changeSetType);
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getTemplateBody() {
            return this.templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateURL() {
            return this.templateURL;
        }

        @Override
        public final Builder templateURL(String templateURL) {
            this.templateURL = templateURL;
            return this;
        }

        public final void setTemplateURL(String templateURL) {
            this.templateURL = templateURL;
        }

        public final Boolean getUsePreviousTemplate() {
            return this.usePreviousTemplate;
        }

        @Override
        public final Builder usePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
            return this;
        }

        public final void setUsePreviousTemplate(Boolean usePreviousTemplate) {
            this.usePreviousTemplate = usePreviousTemplate;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public final Collection<String> getCapabilities() {
            return this.capabilities;
        }

        @Override
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(String ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (String e : capabilities) {
                this.capabilities.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capabilities(Capability ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (Capability ele : capabilities) {
                this.capabilities.add(ele.toString());
            }
            return this;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = CapabilitiesCopier.copy(capabilities);
        }

        @SafeVarargs
        public final void setCapabilities(String ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (String e : capabilities) {
                this.capabilities.add(e);
            }
        }

        @SafeVarargs
        public final void setCapabilities(Capability ... capabilities) {
            if (this.capabilities == null) {
                this.capabilities = new SdkInternalList(capabilities.length);
            }
            for (Capability ele : capabilities) {
                this.capabilities.add(ele.toString());
            }
        }

        public final Collection<String> getResourceTypes() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(String ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (String e : resourceTypes) {
                this.resourceTypes.add(e);
            }
            return this;
        }

        public final void setResourceTypes(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypesCopier.copy(resourceTypes);
        }

        @SafeVarargs
        public final void setResourceTypes(String ... resourceTypes) {
            if (this.resourceTypes == null) {
                this.resourceTypes = new SdkInternalList(resourceTypes.length);
            }
            for (String e : resourceTypes) {
                this.resourceTypes.add(e);
            }
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final Collection<String> getNotificationARNs() {
            return this.notificationARNs;
        }

        @Override
        public final Builder notificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationARNs(String ... notificationARNs) {
            if (this.notificationARNs == null) {
                this.notificationARNs = new SdkInternalList(notificationARNs.length);
            }
            for (String e : notificationARNs) {
                this.notificationARNs.add(e);
            }
            return this;
        }

        public final void setNotificationARNs(Collection<String> notificationARNs) {
            this.notificationARNs = NotificationARNsCopier.copy(notificationARNs);
        }

        @SafeVarargs
        public final void setNotificationARNs(String ... notificationARNs) {
            if (this.notificationARNs == null) {
                this.notificationARNs = new SdkInternalList(notificationARNs.length);
            }
            for (String e : notificationARNs) {
                this.notificationARNs.add(e);
            }
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final Builder changeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        public final void setChangeSetName(String changeSetName) {
            this.changeSetName = changeSetName;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getChangeSetType() {
            return this.changeSetType;
        }

        @Override
        public final Builder changeSetType(String changeSetType) {
            this.changeSetType = changeSetType;
            return this;
        }

        @Override
        public final Builder changeSetType(ChangeSetType changeSetType) {
            this.changeSetType(changeSetType.toString());
            return this;
        }

        public final void setChangeSetType(String changeSetType) {
            this.changeSetType = changeSetType;
        }

        public final void setChangeSetType(ChangeSetType changeSetType) {
            this.changeSetType(changeSetType.toString());
        }

        public CreateChangeSetRequest build() {
            return new CreateChangeSetRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateChangeSetRequest> {
        public Builder stackName(String var1);

        public Builder templateBody(String var1);

        public Builder templateURL(String var1);

        public Builder usePreviousTemplate(Boolean var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);

        public Builder capabilities(Collection<String> var1);

        public Builder capabilities(String ... var1);

        public Builder capabilities(Capability ... var1);

        public Builder resourceTypes(Collection<String> var1);

        public Builder resourceTypes(String ... var1);

        public Builder roleARN(String var1);

        public Builder notificationARNs(Collection<String> var1);

        public Builder notificationARNs(String ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder changeSetName(String var1);

        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder changeSetType(String var1);

        public Builder changeSetType(ChangeSetType var1);
    }
}

