/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateObjectAttributesResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, UpdateObjectAttributesResponse> {
    private static final SdkField<String> OBJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateObjectAttributesResponse.getter(UpdateObjectAttributesResponse::objectIdentifier)).setter(UpdateObjectAttributesResponse.setter(Builder::objectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_IDENTIFIER_FIELD));
    private final String objectIdentifier;

    private UpdateObjectAttributesResponse(BuilderImpl builder) {
        super(builder);
        this.objectIdentifier = builder.objectIdentifier;
    }

    public String objectIdentifier() {
        return this.objectIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.objectIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateObjectAttributesResponse)) {
            return false;
        }
        UpdateObjectAttributesResponse other = (UpdateObjectAttributesResponse)((Object)obj);
        return Objects.equals(this.objectIdentifier(), other.objectIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"UpdateObjectAttributesResponse").add("ObjectIdentifier", (Object)this.objectIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.objectIdentifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateObjectAttributesResponse, T> g) {
        return obj -> g.apply((UpdateObjectAttributesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private String objectIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateObjectAttributesResponse model) {
            super(model);
            this.objectIdentifier(model.objectIdentifier);
        }

        public final String getObjectIdentifier() {
            return this.objectIdentifier;
        }

        @Override
        public final Builder objectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
            return this;
        }

        public final void setObjectIdentifier(String objectIdentifier) {
            this.objectIdentifier = objectIdentifier;
        }

        @Override
        public UpdateObjectAttributesResponse build() {
            return new UpdateObjectAttributesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateObjectAttributesResponse> {
        public Builder objectIdentifier(String var1);
    }
}

