/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.UpdateActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TypedLinkFacetAttributeUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TypedLinkFacetAttributeUpdate> {
    private static final SdkField<TypedLinkAttributeDefinition> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TypedLinkFacetAttributeUpdate.getter(TypedLinkFacetAttributeUpdate::attribute)).setter(TypedLinkFacetAttributeUpdate.setter(Builder::attribute)).constructor(TypedLinkAttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(TypedLinkFacetAttributeUpdate.getter(TypedLinkFacetAttributeUpdate::actionAsString)).setter(TypedLinkFacetAttributeUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, ACTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final TypedLinkAttributeDefinition attribute;
    private final String action;

    private TypedLinkFacetAttributeUpdate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.action = builder.action;
    }

    public TypedLinkAttributeDefinition attribute() {
        return this.attribute;
    }

    public UpdateActionType action() {
        return UpdateActionType.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypedLinkFacetAttributeUpdate)) {
            return false;
        }
        TypedLinkFacetAttributeUpdate other = (TypedLinkFacetAttributeUpdate)obj;
        return Objects.equals(this.attribute(), other.attribute()) && Objects.equals(this.actionAsString(), other.actionAsString());
    }

    public String toString() {
        return ToString.builder((String)"TypedLinkFacetAttributeUpdate").add("Attribute", (Object)this.attribute()).add("Action", (Object)this.actionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attribute": {
                return Optional.ofNullable(clazz.cast(this.attribute()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TypedLinkFacetAttributeUpdate, T> g) {
        return obj -> g.apply((TypedLinkFacetAttributeUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TypedLinkAttributeDefinition attribute;
        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(TypedLinkFacetAttributeUpdate model) {
            this.attribute(model.attribute);
            this.action(model.action);
        }

        public final TypedLinkAttributeDefinition.Builder getAttribute() {
            return this.attribute != null ? this.attribute.toBuilder() : null;
        }

        @Override
        public final Builder attribute(TypedLinkAttributeDefinition attribute) {
            this.attribute = attribute;
            return this;
        }

        public final void setAttribute(TypedLinkAttributeDefinition.BuilderImpl attribute) {
            this.attribute = attribute != null ? attribute.build() : null;
        }

        public final String getActionAsString() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(UpdateActionType action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public TypedLinkFacetAttributeUpdate build() {
            return new TypedLinkFacetAttributeUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TypedLinkFacetAttributeUpdate> {
        public Builder attribute(TypedLinkAttributeDefinition var1);

        default public Builder attribute(Consumer<TypedLinkAttributeDefinition.Builder> attribute) {
            return this.attribute((TypedLinkAttributeDefinition)((TypedLinkAttributeDefinition.Builder)TypedLinkAttributeDefinition.builder().applyMutation(attribute)).build());
        }

        public Builder action(String var1);

        public Builder action(UpdateActionType var1);
    }
}

