/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListPolicyAttachments
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListPolicyAttachments> {
    private static final SdkField<ObjectReference> POLICY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(BatchListPolicyAttachments.getter(BatchListPolicyAttachments::policyReference)).setter(BatchListPolicyAttachments.setter(Builder::policyReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReference").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BatchListPolicyAttachments.getter(BatchListPolicyAttachments::nextToken)).setter(BatchListPolicyAttachments.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BatchListPolicyAttachments.getter(BatchListPolicyAttachments::maxResults)).setter(BatchListPolicyAttachments.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final ObjectReference policyReference;
    private final String nextToken;
    private final Integer maxResults;

    private BatchListPolicyAttachments(BuilderImpl builder) {
        this.policyReference = builder.policyReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public ObjectReference policyReference() {
        return this.policyReference;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListPolicyAttachments)) {
            return false;
        }
        BatchListPolicyAttachments other = (BatchListPolicyAttachments)obj;
        return Objects.equals(this.policyReference(), other.policyReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"BatchListPolicyAttachments").add("PolicyReference", (Object)this.policyReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyReference": {
                return Optional.ofNullable(clazz.cast(this.policyReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchListPolicyAttachments, T> g) {
        return obj -> g.apply((BatchListPolicyAttachments)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ObjectReference policyReference;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListPolicyAttachments model) {
            this.policyReference(model.policyReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final ObjectReference.Builder getPolicyReference() {
            return this.policyReference != null ? this.policyReference.toBuilder() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public BatchListPolicyAttachments build() {
            return new BatchListPolicyAttachments(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListPolicyAttachments> {
        public Builder policyReference(ObjectReference var1);

        default public Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return this.policyReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(policyReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

