/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeNameListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkFacetAttributeUpdateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTypedLinkFacetRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
    private static final SdkField<String> SCHEMA_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTypedLinkFacetRequest.getter(UpdateTypedLinkFacetRequest::schemaArn)).setter(UpdateTypedLinkFacetRequest.setter(Builder::schemaArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateTypedLinkFacetRequest.getter(UpdateTypedLinkFacetRequest::name)).setter(UpdateTypedLinkFacetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<TypedLinkFacetAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateTypedLinkFacetRequest.getter(UpdateTypedLinkFacetRequest::attributeUpdates)).setter(UpdateTypedLinkFacetRequest.setter(Builder::attributeUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypedLinkFacetAttributeUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IDENTITY_ATTRIBUTE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(UpdateTypedLinkFacetRequest.getter(UpdateTypedLinkFacetRequest::identityAttributeOrder)).setter(UpdateTypedLinkFacetRequest.setter(Builder::identityAttributeOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityAttributeOrder").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ARN_FIELD, NAME_FIELD, ATTRIBUTE_UPDATES_FIELD, IDENTITY_ATTRIBUTE_ORDER_FIELD));
    private final String schemaArn;
    private final String name;
    private final List<TypedLinkFacetAttributeUpdate> attributeUpdates;
    private final List<String> identityAttributeOrder;

    private UpdateTypedLinkFacetRequest(BuilderImpl builder) {
        super(builder);
        this.schemaArn = builder.schemaArn;
        this.name = builder.name;
        this.attributeUpdates = builder.attributeUpdates;
        this.identityAttributeOrder = builder.identityAttributeOrder;
    }

    public String schemaArn() {
        return this.schemaArn;
    }

    public String name() {
        return this.name;
    }

    public List<TypedLinkFacetAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public List<String> identityAttributeOrder() {
        return this.identityAttributeOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityAttributeOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTypedLinkFacetRequest)) {
            return false;
        }
        UpdateTypedLinkFacetRequest other = (UpdateTypedLinkFacetRequest)((Object)obj);
        return Objects.equals(this.schemaArn(), other.schemaArn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.attributeUpdates(), other.attributeUpdates()) && Objects.equals(this.identityAttributeOrder(), other.identityAttributeOrder());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTypedLinkFacetRequest").add("SchemaArn", (Object)this.schemaArn()).add("Name", (Object)this.name()).add("AttributeUpdates", this.attributeUpdates()).add("IdentityAttributeOrder", this.identityAttributeOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaArn": {
                return Optional.ofNullable(clazz.cast(this.schemaArn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AttributeUpdates": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdates()));
            }
            case "IdentityAttributeOrder": {
                return Optional.ofNullable(clazz.cast(this.identityAttributeOrder()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTypedLinkFacetRequest, T> g) {
        return obj -> g.apply((UpdateTypedLinkFacetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String schemaArn;
        private String name;
        private List<TypedLinkFacetAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();
        private List<String> identityAttributeOrder = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTypedLinkFacetRequest model) {
            super(model);
            this.schemaArn(model.schemaArn);
            this.name(model.name);
            this.attributeUpdates(model.attributeUpdates);
            this.identityAttributeOrder(model.identityAttributeOrder);
        }

        public final String getSchemaArn() {
            return this.schemaArn;
        }

        @Override
        public final Builder schemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
            return this;
        }

        public final void setSchemaArn(String schemaArn) {
            this.schemaArn = schemaArn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<TypedLinkFacetAttributeUpdate.Builder> getAttributeUpdates() {
            return this.attributeUpdates != null ? (Collection)this.attributeUpdates.stream().map(TypedLinkFacetAttributeUpdate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(TypedLinkFacetAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<TypedLinkFacetAttributeUpdate.Builder> ... attributeUpdates) {
            this.attributeUpdates(Stream.of(attributeUpdates).map(c -> (TypedLinkFacetAttributeUpdate)((TypedLinkFacetAttributeUpdate.Builder)TypedLinkFacetAttributeUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributeUpdates(Collection<TypedLinkFacetAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = TypedLinkFacetAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        public final Collection<String> getIdentityAttributeOrder() {
            return this.identityAttributeOrder;
        }

        @Override
        public final Builder identityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identityAttributeOrder(String ... identityAttributeOrder) {
            this.identityAttributeOrder(Arrays.asList(identityAttributeOrder));
            return this;
        }

        public final void setIdentityAttributeOrder(Collection<String> identityAttributeOrder) {
            this.identityAttributeOrder = AttributeNameListCopier.copy(identityAttributeOrder);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTypedLinkFacetRequest build() {
            return new UpdateTypedLinkFacetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTypedLinkFacetRequest> {
        public Builder schemaArn(String var1);

        public Builder name(String var1);

        public Builder attributeUpdates(Collection<TypedLinkFacetAttributeUpdate> var1);

        public Builder attributeUpdates(TypedLinkFacetAttributeUpdate ... var1);

        public Builder attributeUpdates(Consumer<TypedLinkFacetAttributeUpdate.Builder> ... var1);

        public Builder identityAttributeOrder(Collection<String> var1);

        public Builder identityAttributeOrder(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

