/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdate;
import software.amazon.awssdk.services.clouddirectory.model.LinkAttributeUpdateListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSpecifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateLinkAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchUpdateLinkAttributes> {
    private static final SdkField<TypedLinkSpecifier> TYPED_LINK_SPECIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TypedLinkSpecifier").getter(BatchUpdateLinkAttributes.getter(BatchUpdateLinkAttributes::typedLinkSpecifier)).setter(BatchUpdateLinkAttributes.setter(Builder::typedLinkSpecifier)).constructor(TypedLinkSpecifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypedLinkSpecifier").build()}).build();
    private static final SdkField<List<LinkAttributeUpdate>> ATTRIBUTE_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttributeUpdates").getter(BatchUpdateLinkAttributes.getter(BatchUpdateLinkAttributes::attributeUpdates)).setter(BatchUpdateLinkAttributes.setter(Builder::attributeUpdates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeUpdates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LinkAttributeUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPED_LINK_SPECIFIER_FIELD, ATTRIBUTE_UPDATES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateLinkAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TypedLinkSpecifier typedLinkSpecifier;
    private final List<LinkAttributeUpdate> attributeUpdates;

    private BatchUpdateLinkAttributes(BuilderImpl builder) {
        this.typedLinkSpecifier = builder.typedLinkSpecifier;
        this.attributeUpdates = builder.attributeUpdates;
    }

    public final TypedLinkSpecifier typedLinkSpecifier() {
        return this.typedLinkSpecifier;
    }

    public final boolean hasAttributeUpdates() {
        return this.attributeUpdates != null && !(this.attributeUpdates instanceof SdkAutoConstructList);
    }

    public final List<LinkAttributeUpdate> attributeUpdates() {
        return this.attributeUpdates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typedLinkSpecifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributeUpdates() ? this.attributeUpdates() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateLinkAttributes)) {
            return false;
        }
        BatchUpdateLinkAttributes other = (BatchUpdateLinkAttributes)obj;
        return Objects.equals(this.typedLinkSpecifier(), other.typedLinkSpecifier()) && this.hasAttributeUpdates() == other.hasAttributeUpdates() && Objects.equals(this.attributeUpdates(), other.attributeUpdates());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateLinkAttributes").add("TypedLinkSpecifier", (Object)this.typedLinkSpecifier()).add("AttributeUpdates", this.hasAttributeUpdates() ? this.attributeUpdates() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TypedLinkSpecifier": {
                return Optional.ofNullable(clazz.cast(this.typedLinkSpecifier()));
            }
            case "AttributeUpdates": {
                return Optional.ofNullable(clazz.cast(this.attributeUpdates()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TypedLinkSpecifier", TYPED_LINK_SPECIFIER_FIELD);
        map.put("AttributeUpdates", ATTRIBUTE_UPDATES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateLinkAttributes, T> g) {
        return obj -> g.apply((BatchUpdateLinkAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private TypedLinkSpecifier typedLinkSpecifier;
        private List<LinkAttributeUpdate> attributeUpdates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateLinkAttributes model) {
            this.typedLinkSpecifier(model.typedLinkSpecifier);
            this.attributeUpdates(model.attributeUpdates);
        }

        public final TypedLinkSpecifier.Builder getTypedLinkSpecifier() {
            return this.typedLinkSpecifier != null ? this.typedLinkSpecifier.toBuilder() : null;
        }

        public final void setTypedLinkSpecifier(TypedLinkSpecifier.BuilderImpl typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier != null ? typedLinkSpecifier.build() : null;
        }

        @Override
        public final Builder typedLinkSpecifier(TypedLinkSpecifier typedLinkSpecifier) {
            this.typedLinkSpecifier = typedLinkSpecifier;
            return this;
        }

        public final List<LinkAttributeUpdate.Builder> getAttributeUpdates() {
            List<LinkAttributeUpdate.Builder> result = LinkAttributeUpdateListCopier.copyToBuilder(this.attributeUpdates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeUpdates(Collection<LinkAttributeUpdate.BuilderImpl> attributeUpdates) {
            this.attributeUpdates = LinkAttributeUpdateListCopier.copyFromBuilder(attributeUpdates);
        }

        @Override
        public final Builder attributeUpdates(Collection<LinkAttributeUpdate> attributeUpdates) {
            this.attributeUpdates = LinkAttributeUpdateListCopier.copy(attributeUpdates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(LinkAttributeUpdate ... attributeUpdates) {
            this.attributeUpdates(Arrays.asList(attributeUpdates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeUpdates(Consumer<LinkAttributeUpdate.Builder> ... attributeUpdates) {
            this.attributeUpdates(Stream.of(attributeUpdates).map(c -> (LinkAttributeUpdate)((LinkAttributeUpdate.Builder)LinkAttributeUpdate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public BatchUpdateLinkAttributes build() {
            return new BatchUpdateLinkAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchUpdateLinkAttributes> {
        public Builder typedLinkSpecifier(TypedLinkSpecifier var1);

        default public Builder typedLinkSpecifier(Consumer<TypedLinkSpecifier.Builder> typedLinkSpecifier) {
            return this.typedLinkSpecifier((TypedLinkSpecifier)((TypedLinkSpecifier.Builder)TypedLinkSpecifier.builder().applyMutation(typedLinkSpecifier)).build());
        }

        public Builder attributeUpdates(Collection<LinkAttributeUpdate> var1);

        public Builder attributeUpdates(LinkAttributeUpdate ... var1);

        public Builder attributeUpdates(Consumer<LinkAttributeUpdate.Builder> ... var1);
    }
}

