/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndexResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicyResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLinkResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObjectResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributesResponse;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteOperationResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchWriteOperationResponse> {
    private static final SdkField<BatchCreateObjectResponse> CREATE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateObject").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::createObject)).setter(BatchWriteOperationResponse.setter(Builder::createObject)).constructor(BatchCreateObjectResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateObject").build()}).build();
    private static final SdkField<BatchAttachObjectResponse> ATTACH_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachObject").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::attachObject)).setter(BatchWriteOperationResponse.setter(Builder::attachObject)).constructor(BatchAttachObjectResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachObject").build()}).build();
    private static final SdkField<BatchDetachObjectResponse> DETACH_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachObject").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::detachObject)).setter(BatchWriteOperationResponse.setter(Builder::detachObject)).constructor(BatchDetachObjectResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachObject").build()}).build();
    private static final SdkField<BatchUpdateObjectAttributesResponse> UPDATE_OBJECT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateObjectAttributes").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::updateObjectAttributes)).setter(BatchWriteOperationResponse.setter(Builder::updateObjectAttributes)).constructor(BatchUpdateObjectAttributesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateObjectAttributes").build()}).build();
    private static final SdkField<BatchDeleteObjectResponse> DELETE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeleteObject").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::deleteObject)).setter(BatchWriteOperationResponse.setter(Builder::deleteObject)).constructor(BatchDeleteObjectResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteObject").build()}).build();
    private static final SdkField<BatchAddFacetToObjectResponse> ADD_FACET_TO_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AddFacetToObject").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::addFacetToObject)).setter(BatchWriteOperationResponse.setter(Builder::addFacetToObject)).constructor(BatchAddFacetToObjectResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddFacetToObject").build()}).build();
    private static final SdkField<BatchRemoveFacetFromObjectResponse> REMOVE_FACET_FROM_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoveFacetFromObject").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::removeFacetFromObject)).setter(BatchWriteOperationResponse.setter(Builder::removeFacetFromObject)).constructor(BatchRemoveFacetFromObjectResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveFacetFromObject").build()}).build();
    private static final SdkField<BatchAttachPolicyResponse> ATTACH_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachPolicy").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::attachPolicy)).setter(BatchWriteOperationResponse.setter(Builder::attachPolicy)).constructor(BatchAttachPolicyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachPolicy").build()}).build();
    private static final SdkField<BatchDetachPolicyResponse> DETACH_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachPolicy").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::detachPolicy)).setter(BatchWriteOperationResponse.setter(Builder::detachPolicy)).constructor(BatchDetachPolicyResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachPolicy").build()}).build();
    private static final SdkField<BatchCreateIndexResponse> CREATE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateIndex").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::createIndex)).setter(BatchWriteOperationResponse.setter(Builder::createIndex)).constructor(BatchCreateIndexResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateIndex").build()}).build();
    private static final SdkField<BatchAttachToIndexResponse> ATTACH_TO_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachToIndex").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::attachToIndex)).setter(BatchWriteOperationResponse.setter(Builder::attachToIndex)).constructor(BatchAttachToIndexResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachToIndex").build()}).build();
    private static final SdkField<BatchDetachFromIndexResponse> DETACH_FROM_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachFromIndex").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::detachFromIndex)).setter(BatchWriteOperationResponse.setter(Builder::detachFromIndex)).constructor(BatchDetachFromIndexResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachFromIndex").build()}).build();
    private static final SdkField<BatchAttachTypedLinkResponse> ATTACH_TYPED_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachTypedLink").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::attachTypedLink)).setter(BatchWriteOperationResponse.setter(Builder::attachTypedLink)).constructor(BatchAttachTypedLinkResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTypedLink").build()}).build();
    private static final SdkField<BatchDetachTypedLinkResponse> DETACH_TYPED_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachTypedLink").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::detachTypedLink)).setter(BatchWriteOperationResponse.setter(Builder::detachTypedLink)).constructor(BatchDetachTypedLinkResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachTypedLink").build()}).build();
    private static final SdkField<BatchUpdateLinkAttributesResponse> UPDATE_LINK_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateLinkAttributes").getter(BatchWriteOperationResponse.getter(BatchWriteOperationResponse::updateLinkAttributes)).setter(BatchWriteOperationResponse.setter(Builder::updateLinkAttributes)).constructor(BatchUpdateLinkAttributesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateLinkAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_OBJECT_FIELD, ATTACH_OBJECT_FIELD, DETACH_OBJECT_FIELD, UPDATE_OBJECT_ATTRIBUTES_FIELD, DELETE_OBJECT_FIELD, ADD_FACET_TO_OBJECT_FIELD, REMOVE_FACET_FROM_OBJECT_FIELD, ATTACH_POLICY_FIELD, DETACH_POLICY_FIELD, CREATE_INDEX_FIELD, ATTACH_TO_INDEX_FIELD, DETACH_FROM_INDEX_FIELD, ATTACH_TYPED_LINK_FIELD, DETACH_TYPED_LINK_FIELD, UPDATE_LINK_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchWriteOperationResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final BatchCreateObjectResponse createObject;
    private final BatchAttachObjectResponse attachObject;
    private final BatchDetachObjectResponse detachObject;
    private final BatchUpdateObjectAttributesResponse updateObjectAttributes;
    private final BatchDeleteObjectResponse deleteObject;
    private final BatchAddFacetToObjectResponse addFacetToObject;
    private final BatchRemoveFacetFromObjectResponse removeFacetFromObject;
    private final BatchAttachPolicyResponse attachPolicy;
    private final BatchDetachPolicyResponse detachPolicy;
    private final BatchCreateIndexResponse createIndex;
    private final BatchAttachToIndexResponse attachToIndex;
    private final BatchDetachFromIndexResponse detachFromIndex;
    private final BatchAttachTypedLinkResponse attachTypedLink;
    private final BatchDetachTypedLinkResponse detachTypedLink;
    private final BatchUpdateLinkAttributesResponse updateLinkAttributes;

    private BatchWriteOperationResponse(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
        this.attachPolicy = builder.attachPolicy;
        this.detachPolicy = builder.detachPolicy;
        this.createIndex = builder.createIndex;
        this.attachToIndex = builder.attachToIndex;
        this.detachFromIndex = builder.detachFromIndex;
        this.attachTypedLink = builder.attachTypedLink;
        this.detachTypedLink = builder.detachTypedLink;
        this.updateLinkAttributes = builder.updateLinkAttributes;
    }

    public final BatchCreateObjectResponse createObject() {
        return this.createObject;
    }

    public final BatchAttachObjectResponse attachObject() {
        return this.attachObject;
    }

    public final BatchDetachObjectResponse detachObject() {
        return this.detachObject;
    }

    public final BatchUpdateObjectAttributesResponse updateObjectAttributes() {
        return this.updateObjectAttributes;
    }

    public final BatchDeleteObjectResponse deleteObject() {
        return this.deleteObject;
    }

    public final BatchAddFacetToObjectResponse addFacetToObject() {
        return this.addFacetToObject;
    }

    public final BatchRemoveFacetFromObjectResponse removeFacetFromObject() {
        return this.removeFacetFromObject;
    }

    public final BatchAttachPolicyResponse attachPolicy() {
        return this.attachPolicy;
    }

    public final BatchDetachPolicyResponse detachPolicy() {
        return this.detachPolicy;
    }

    public final BatchCreateIndexResponse createIndex() {
        return this.createIndex;
    }

    public final BatchAttachToIndexResponse attachToIndex() {
        return this.attachToIndex;
    }

    public final BatchDetachFromIndexResponse detachFromIndex() {
        return this.detachFromIndex;
    }

    public final BatchAttachTypedLinkResponse attachTypedLink() {
        return this.attachTypedLink;
    }

    public final BatchDetachTypedLinkResponse detachTypedLink() {
        return this.detachTypedLink;
    }

    public final BatchUpdateLinkAttributesResponse updateLinkAttributes() {
        return this.updateLinkAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.addFacetToObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeFacetFromObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachToIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachFromIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateLinkAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperationResponse)) {
            return false;
        }
        BatchWriteOperationResponse other = (BatchWriteOperationResponse)obj;
        return Objects.equals(this.createObject(), other.createObject()) && Objects.equals(this.attachObject(), other.attachObject()) && Objects.equals(this.detachObject(), other.detachObject()) && Objects.equals(this.updateObjectAttributes(), other.updateObjectAttributes()) && Objects.equals(this.deleteObject(), other.deleteObject()) && Objects.equals(this.addFacetToObject(), other.addFacetToObject()) && Objects.equals(this.removeFacetFromObject(), other.removeFacetFromObject()) && Objects.equals(this.attachPolicy(), other.attachPolicy()) && Objects.equals(this.detachPolicy(), other.detachPolicy()) && Objects.equals(this.createIndex(), other.createIndex()) && Objects.equals(this.attachToIndex(), other.attachToIndex()) && Objects.equals(this.detachFromIndex(), other.detachFromIndex()) && Objects.equals(this.attachTypedLink(), other.attachTypedLink()) && Objects.equals(this.detachTypedLink(), other.detachTypedLink()) && Objects.equals(this.updateLinkAttributes(), other.updateLinkAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchWriteOperationResponse").add("CreateObject", (Object)this.createObject()).add("AttachObject", (Object)this.attachObject()).add("DetachObject", (Object)this.detachObject()).add("UpdateObjectAttributes", (Object)this.updateObjectAttributes()).add("DeleteObject", (Object)this.deleteObject()).add("AddFacetToObject", (Object)this.addFacetToObject()).add("RemoveFacetFromObject", (Object)this.removeFacetFromObject()).add("AttachPolicy", (Object)this.attachPolicy()).add("DetachPolicy", (Object)this.detachPolicy()).add("CreateIndex", (Object)this.createIndex()).add("AttachToIndex", (Object)this.attachToIndex()).add("DetachFromIndex", (Object)this.detachFromIndex()).add("AttachTypedLink", (Object)this.attachTypedLink()).add("DetachTypedLink", (Object)this.detachTypedLink()).add("UpdateLinkAttributes", (Object)this.updateLinkAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateObject": {
                return Optional.ofNullable(clazz.cast(this.createObject()));
            }
            case "AttachObject": {
                return Optional.ofNullable(clazz.cast(this.attachObject()));
            }
            case "DetachObject": {
                return Optional.ofNullable(clazz.cast(this.detachObject()));
            }
            case "UpdateObjectAttributes": {
                return Optional.ofNullable(clazz.cast(this.updateObjectAttributes()));
            }
            case "DeleteObject": {
                return Optional.ofNullable(clazz.cast(this.deleteObject()));
            }
            case "AddFacetToObject": {
                return Optional.ofNullable(clazz.cast(this.addFacetToObject()));
            }
            case "RemoveFacetFromObject": {
                return Optional.ofNullable(clazz.cast(this.removeFacetFromObject()));
            }
            case "AttachPolicy": {
                return Optional.ofNullable(clazz.cast(this.attachPolicy()));
            }
            case "DetachPolicy": {
                return Optional.ofNullable(clazz.cast(this.detachPolicy()));
            }
            case "CreateIndex": {
                return Optional.ofNullable(clazz.cast(this.createIndex()));
            }
            case "AttachToIndex": {
                return Optional.ofNullable(clazz.cast(this.attachToIndex()));
            }
            case "DetachFromIndex": {
                return Optional.ofNullable(clazz.cast(this.detachFromIndex()));
            }
            case "AttachTypedLink": {
                return Optional.ofNullable(clazz.cast(this.attachTypedLink()));
            }
            case "DetachTypedLink": {
                return Optional.ofNullable(clazz.cast(this.detachTypedLink()));
            }
            case "UpdateLinkAttributes": {
                return Optional.ofNullable(clazz.cast(this.updateLinkAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreateObject", CREATE_OBJECT_FIELD);
        map.put("AttachObject", ATTACH_OBJECT_FIELD);
        map.put("DetachObject", DETACH_OBJECT_FIELD);
        map.put("UpdateObjectAttributes", UPDATE_OBJECT_ATTRIBUTES_FIELD);
        map.put("DeleteObject", DELETE_OBJECT_FIELD);
        map.put("AddFacetToObject", ADD_FACET_TO_OBJECT_FIELD);
        map.put("RemoveFacetFromObject", REMOVE_FACET_FROM_OBJECT_FIELD);
        map.put("AttachPolicy", ATTACH_POLICY_FIELD);
        map.put("DetachPolicy", DETACH_POLICY_FIELD);
        map.put("CreateIndex", CREATE_INDEX_FIELD);
        map.put("AttachToIndex", ATTACH_TO_INDEX_FIELD);
        map.put("DetachFromIndex", DETACH_FROM_INDEX_FIELD);
        map.put("AttachTypedLink", ATTACH_TYPED_LINK_FIELD);
        map.put("DetachTypedLink", DETACH_TYPED_LINK_FIELD);
        map.put("UpdateLinkAttributes", UPDATE_LINK_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteOperationResponse, T> g) {
        return obj -> g.apply((BatchWriteOperationResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchCreateObjectResponse createObject;
        private BatchAttachObjectResponse attachObject;
        private BatchDetachObjectResponse detachObject;
        private BatchUpdateObjectAttributesResponse updateObjectAttributes;
        private BatchDeleteObjectResponse deleteObject;
        private BatchAddFacetToObjectResponse addFacetToObject;
        private BatchRemoveFacetFromObjectResponse removeFacetFromObject;
        private BatchAttachPolicyResponse attachPolicy;
        private BatchDetachPolicyResponse detachPolicy;
        private BatchCreateIndexResponse createIndex;
        private BatchAttachToIndexResponse attachToIndex;
        private BatchDetachFromIndexResponse detachFromIndex;
        private BatchAttachTypedLinkResponse attachTypedLink;
        private BatchDetachTypedLinkResponse detachTypedLink;
        private BatchUpdateLinkAttributesResponse updateLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperationResponse model) {
            this.createObject(model.createObject);
            this.attachObject(model.attachObject);
            this.detachObject(model.detachObject);
            this.updateObjectAttributes(model.updateObjectAttributes);
            this.deleteObject(model.deleteObject);
            this.addFacetToObject(model.addFacetToObject);
            this.removeFacetFromObject(model.removeFacetFromObject);
            this.attachPolicy(model.attachPolicy);
            this.detachPolicy(model.detachPolicy);
            this.createIndex(model.createIndex);
            this.attachToIndex(model.attachToIndex);
            this.detachFromIndex(model.detachFromIndex);
            this.attachTypedLink(model.attachTypedLink);
            this.detachTypedLink(model.detachTypedLink);
            this.updateLinkAttributes(model.updateLinkAttributes);
        }

        public final BatchCreateObjectResponse.Builder getCreateObject() {
            return this.createObject != null ? this.createObject.toBuilder() : null;
        }

        public final void setCreateObject(BatchCreateObjectResponse.BuilderImpl createObject) {
            this.createObject = createObject != null ? createObject.build() : null;
        }

        @Override
        public final Builder createObject(BatchCreateObjectResponse createObject) {
            this.createObject = createObject;
            return this;
        }

        public final BatchAttachObjectResponse.Builder getAttachObject() {
            return this.attachObject != null ? this.attachObject.toBuilder() : null;
        }

        public final void setAttachObject(BatchAttachObjectResponse.BuilderImpl attachObject) {
            this.attachObject = attachObject != null ? attachObject.build() : null;
        }

        @Override
        public final Builder attachObject(BatchAttachObjectResponse attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final BatchDetachObjectResponse.Builder getDetachObject() {
            return this.detachObject != null ? this.detachObject.toBuilder() : null;
        }

        public final void setDetachObject(BatchDetachObjectResponse.BuilderImpl detachObject) {
            this.detachObject = detachObject != null ? detachObject.build() : null;
        }

        @Override
        public final Builder detachObject(BatchDetachObjectResponse detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final BatchUpdateObjectAttributesResponse.Builder getUpdateObjectAttributes() {
            return this.updateObjectAttributes != null ? this.updateObjectAttributes.toBuilder() : null;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributesResponse.BuilderImpl updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes != null ? updateObjectAttributes.build() : null;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final BatchDeleteObjectResponse.Builder getDeleteObject() {
            return this.deleteObject != null ? this.deleteObject.toBuilder() : null;
        }

        public final void setDeleteObject(BatchDeleteObjectResponse.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObjectResponse deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final BatchAddFacetToObjectResponse.Builder getAddFacetToObject() {
            return this.addFacetToObject != null ? this.addFacetToObject.toBuilder() : null;
        }

        public final void setAddFacetToObject(BatchAddFacetToObjectResponse.BuilderImpl addFacetToObject) {
            this.addFacetToObject = addFacetToObject != null ? addFacetToObject.build() : null;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObjectResponse addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final BatchRemoveFacetFromObjectResponse.Builder getRemoveFacetFromObject() {
            return this.removeFacetFromObject != null ? this.removeFacetFromObject.toBuilder() : null;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObjectResponse.BuilderImpl removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject != null ? removeFacetFromObject.build() : null;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final BatchAttachPolicyResponse.Builder getAttachPolicy() {
            return this.attachPolicy != null ? this.attachPolicy.toBuilder() : null;
        }

        public final void setAttachPolicy(BatchAttachPolicyResponse.BuilderImpl attachPolicy) {
            this.attachPolicy = attachPolicy != null ? attachPolicy.build() : null;
        }

        @Override
        public final Builder attachPolicy(BatchAttachPolicyResponse attachPolicy) {
            this.attachPolicy = attachPolicy;
            return this;
        }

        public final BatchDetachPolicyResponse.Builder getDetachPolicy() {
            return this.detachPolicy != null ? this.detachPolicy.toBuilder() : null;
        }

        public final void setDetachPolicy(BatchDetachPolicyResponse.BuilderImpl detachPolicy) {
            this.detachPolicy = detachPolicy != null ? detachPolicy.build() : null;
        }

        @Override
        public final Builder detachPolicy(BatchDetachPolicyResponse detachPolicy) {
            this.detachPolicy = detachPolicy;
            return this;
        }

        public final BatchCreateIndexResponse.Builder getCreateIndex() {
            return this.createIndex != null ? this.createIndex.toBuilder() : null;
        }

        public final void setCreateIndex(BatchCreateIndexResponse.BuilderImpl createIndex) {
            this.createIndex = createIndex != null ? createIndex.build() : null;
        }

        @Override
        public final Builder createIndex(BatchCreateIndexResponse createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        public final BatchAttachToIndexResponse.Builder getAttachToIndex() {
            return this.attachToIndex != null ? this.attachToIndex.toBuilder() : null;
        }

        public final void setAttachToIndex(BatchAttachToIndexResponse.BuilderImpl attachToIndex) {
            this.attachToIndex = attachToIndex != null ? attachToIndex.build() : null;
        }

        @Override
        public final Builder attachToIndex(BatchAttachToIndexResponse attachToIndex) {
            this.attachToIndex = attachToIndex;
            return this;
        }

        public final BatchDetachFromIndexResponse.Builder getDetachFromIndex() {
            return this.detachFromIndex != null ? this.detachFromIndex.toBuilder() : null;
        }

        public final void setDetachFromIndex(BatchDetachFromIndexResponse.BuilderImpl detachFromIndex) {
            this.detachFromIndex = detachFromIndex != null ? detachFromIndex.build() : null;
        }

        @Override
        public final Builder detachFromIndex(BatchDetachFromIndexResponse detachFromIndex) {
            this.detachFromIndex = detachFromIndex;
            return this;
        }

        public final BatchAttachTypedLinkResponse.Builder getAttachTypedLink() {
            return this.attachTypedLink != null ? this.attachTypedLink.toBuilder() : null;
        }

        public final void setAttachTypedLink(BatchAttachTypedLinkResponse.BuilderImpl attachTypedLink) {
            this.attachTypedLink = attachTypedLink != null ? attachTypedLink.build() : null;
        }

        @Override
        public final Builder attachTypedLink(BatchAttachTypedLinkResponse attachTypedLink) {
            this.attachTypedLink = attachTypedLink;
            return this;
        }

        public final BatchDetachTypedLinkResponse.Builder getDetachTypedLink() {
            return this.detachTypedLink != null ? this.detachTypedLink.toBuilder() : null;
        }

        public final void setDetachTypedLink(BatchDetachTypedLinkResponse.BuilderImpl detachTypedLink) {
            this.detachTypedLink = detachTypedLink != null ? detachTypedLink.build() : null;
        }

        @Override
        public final Builder detachTypedLink(BatchDetachTypedLinkResponse detachTypedLink) {
            this.detachTypedLink = detachTypedLink;
            return this;
        }

        public final BatchUpdateLinkAttributesResponse.Builder getUpdateLinkAttributes() {
            return this.updateLinkAttributes != null ? this.updateLinkAttributes.toBuilder() : null;
        }

        public final void setUpdateLinkAttributes(BatchUpdateLinkAttributesResponse.BuilderImpl updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes != null ? updateLinkAttributes.build() : null;
        }

        @Override
        public final Builder updateLinkAttributes(BatchUpdateLinkAttributesResponse updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes;
            return this;
        }

        public BatchWriteOperationResponse build() {
            return new BatchWriteOperationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchWriteOperationResponse> {
        public Builder createObject(BatchCreateObjectResponse var1);

        default public Builder createObject(Consumer<BatchCreateObjectResponse.Builder> createObject) {
            return this.createObject((BatchCreateObjectResponse)((BatchCreateObjectResponse.Builder)BatchCreateObjectResponse.builder().applyMutation(createObject)).build());
        }

        public Builder attachObject(BatchAttachObjectResponse var1);

        default public Builder attachObject(Consumer<BatchAttachObjectResponse.Builder> attachObject) {
            return this.attachObject((BatchAttachObjectResponse)((BatchAttachObjectResponse.Builder)BatchAttachObjectResponse.builder().applyMutation(attachObject)).build());
        }

        public Builder detachObject(BatchDetachObjectResponse var1);

        default public Builder detachObject(Consumer<BatchDetachObjectResponse.Builder> detachObject) {
            return this.detachObject((BatchDetachObjectResponse)((BatchDetachObjectResponse.Builder)BatchDetachObjectResponse.builder().applyMutation(detachObject)).build());
        }

        public Builder updateObjectAttributes(BatchUpdateObjectAttributesResponse var1);

        default public Builder updateObjectAttributes(Consumer<BatchUpdateObjectAttributesResponse.Builder> updateObjectAttributes) {
            return this.updateObjectAttributes((BatchUpdateObjectAttributesResponse)((BatchUpdateObjectAttributesResponse.Builder)BatchUpdateObjectAttributesResponse.builder().applyMutation(updateObjectAttributes)).build());
        }

        public Builder deleteObject(BatchDeleteObjectResponse var1);

        default public Builder deleteObject(Consumer<BatchDeleteObjectResponse.Builder> deleteObject) {
            return this.deleteObject((BatchDeleteObjectResponse)((BatchDeleteObjectResponse.Builder)BatchDeleteObjectResponse.builder().applyMutation(deleteObject)).build());
        }

        public Builder addFacetToObject(BatchAddFacetToObjectResponse var1);

        default public Builder addFacetToObject(Consumer<BatchAddFacetToObjectResponse.Builder> addFacetToObject) {
            return this.addFacetToObject((BatchAddFacetToObjectResponse)((BatchAddFacetToObjectResponse.Builder)BatchAddFacetToObjectResponse.builder().applyMutation(addFacetToObject)).build());
        }

        public Builder removeFacetFromObject(BatchRemoveFacetFromObjectResponse var1);

        default public Builder removeFacetFromObject(Consumer<BatchRemoveFacetFromObjectResponse.Builder> removeFacetFromObject) {
            return this.removeFacetFromObject((BatchRemoveFacetFromObjectResponse)((BatchRemoveFacetFromObjectResponse.Builder)BatchRemoveFacetFromObjectResponse.builder().applyMutation(removeFacetFromObject)).build());
        }

        public Builder attachPolicy(BatchAttachPolicyResponse var1);

        default public Builder attachPolicy(Consumer<BatchAttachPolicyResponse.Builder> attachPolicy) {
            return this.attachPolicy((BatchAttachPolicyResponse)((BatchAttachPolicyResponse.Builder)BatchAttachPolicyResponse.builder().applyMutation(attachPolicy)).build());
        }

        public Builder detachPolicy(BatchDetachPolicyResponse var1);

        default public Builder detachPolicy(Consumer<BatchDetachPolicyResponse.Builder> detachPolicy) {
            return this.detachPolicy((BatchDetachPolicyResponse)((BatchDetachPolicyResponse.Builder)BatchDetachPolicyResponse.builder().applyMutation(detachPolicy)).build());
        }

        public Builder createIndex(BatchCreateIndexResponse var1);

        default public Builder createIndex(Consumer<BatchCreateIndexResponse.Builder> createIndex) {
            return this.createIndex((BatchCreateIndexResponse)((BatchCreateIndexResponse.Builder)BatchCreateIndexResponse.builder().applyMutation(createIndex)).build());
        }

        public Builder attachToIndex(BatchAttachToIndexResponse var1);

        default public Builder attachToIndex(Consumer<BatchAttachToIndexResponse.Builder> attachToIndex) {
            return this.attachToIndex((BatchAttachToIndexResponse)((BatchAttachToIndexResponse.Builder)BatchAttachToIndexResponse.builder().applyMutation(attachToIndex)).build());
        }

        public Builder detachFromIndex(BatchDetachFromIndexResponse var1);

        default public Builder detachFromIndex(Consumer<BatchDetachFromIndexResponse.Builder> detachFromIndex) {
            return this.detachFromIndex((BatchDetachFromIndexResponse)((BatchDetachFromIndexResponse.Builder)BatchDetachFromIndexResponse.builder().applyMutation(detachFromIndex)).build());
        }

        public Builder attachTypedLink(BatchAttachTypedLinkResponse var1);

        default public Builder attachTypedLink(Consumer<BatchAttachTypedLinkResponse.Builder> attachTypedLink) {
            return this.attachTypedLink((BatchAttachTypedLinkResponse)((BatchAttachTypedLinkResponse.Builder)BatchAttachTypedLinkResponse.builder().applyMutation(attachTypedLink)).build());
        }

        public Builder detachTypedLink(BatchDetachTypedLinkResponse var1);

        default public Builder detachTypedLink(Consumer<BatchDetachTypedLinkResponse.Builder> detachTypedLink) {
            return this.detachTypedLink((BatchDetachTypedLinkResponse)((BatchDetachTypedLinkResponse.Builder)BatchDetachTypedLinkResponse.builder().applyMutation(detachTypedLink)).build());
        }

        public Builder updateLinkAttributes(BatchUpdateLinkAttributesResponse var1);

        default public Builder updateLinkAttributes(Consumer<BatchUpdateLinkAttributesResponse.Builder> updateLinkAttributes) {
            return this.updateLinkAttributes((BatchUpdateLinkAttributesResponse)((BatchUpdateLinkAttributesResponse.Builder)BatchUpdateLinkAttributesResponse.builder().applyMutation(updateLinkAttributes)).build());
        }
    }
}

