/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValue;
import software.amazon.awssdk.services.clouddirectory.model.AttributeKeyAndValueListCopier;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacet;
import software.amazon.awssdk.services.clouddirectory.model.SchemaFacetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateObjectRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, CreateObjectRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(CreateObjectRequest.getter(CreateObjectRequest::directoryArn)).setter(CreateObjectRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<List<SchemaFacet>> SCHEMA_FACETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SchemaFacets").getter(CreateObjectRequest.getter(CreateObjectRequest::schemaFacets)).setter(CreateObjectRequest.setter(Builder::schemaFacets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaFacets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaFacet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttributeKeyAndValue>> OBJECT_ATTRIBUTE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectAttributeList").getter(CreateObjectRequest.getter(CreateObjectRequest::objectAttributeList)).setter(CreateObjectRequest.setter(Builder::objectAttributeList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectAttributeList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeKeyAndValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ObjectReference> PARENT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ParentReference").getter(CreateObjectRequest.getter(CreateObjectRequest::parentReference)).setter(CreateObjectRequest.setter(Builder::parentReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentReference").build()}).build();
    private static final SdkField<String> LINK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LinkName").getter(CreateObjectRequest.getter(CreateObjectRequest::linkName)).setter(CreateObjectRequest.setter(Builder::linkName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LinkName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, SCHEMA_FACETS_FIELD, OBJECT_ATTRIBUTE_LIST_FIELD, PARENT_REFERENCE_FIELD, LINK_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateObjectRequest.memberNameToFieldInitializer();
    private final String directoryArn;
    private final List<SchemaFacet> schemaFacets;
    private final List<AttributeKeyAndValue> objectAttributeList;
    private final ObjectReference parentReference;
    private final String linkName;

    private CreateObjectRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.schemaFacets = builder.schemaFacets;
        this.objectAttributeList = builder.objectAttributeList;
        this.parentReference = builder.parentReference;
        this.linkName = builder.linkName;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final boolean hasSchemaFacets() {
        return this.schemaFacets != null && !(this.schemaFacets instanceof SdkAutoConstructList);
    }

    public final List<SchemaFacet> schemaFacets() {
        return this.schemaFacets;
    }

    public final boolean hasObjectAttributeList() {
        return this.objectAttributeList != null && !(this.objectAttributeList instanceof SdkAutoConstructList);
    }

    public final List<AttributeKeyAndValue> objectAttributeList() {
        return this.objectAttributeList;
    }

    public final ObjectReference parentReference() {
        return this.parentReference;
    }

    public final String linkName() {
        return this.linkName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSchemaFacets() ? this.schemaFacets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectAttributeList() ? this.objectAttributeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.parentReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.linkName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateObjectRequest)) {
            return false;
        }
        CreateObjectRequest other = (CreateObjectRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && this.hasSchemaFacets() == other.hasSchemaFacets() && Objects.equals(this.schemaFacets(), other.schemaFacets()) && this.hasObjectAttributeList() == other.hasObjectAttributeList() && Objects.equals(this.objectAttributeList(), other.objectAttributeList()) && Objects.equals(this.parentReference(), other.parentReference()) && Objects.equals(this.linkName(), other.linkName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateObjectRequest").add("DirectoryArn", (Object)this.directoryArn()).add("SchemaFacets", this.hasSchemaFacets() ? this.schemaFacets() : null).add("ObjectAttributeList", this.hasObjectAttributeList() ? this.objectAttributeList() : null).add("ParentReference", (Object)this.parentReference()).add("LinkName", (Object)this.linkName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "SchemaFacets": {
                return Optional.ofNullable(clazz.cast(this.schemaFacets()));
            }
            case "ObjectAttributeList": {
                return Optional.ofNullable(clazz.cast(this.objectAttributeList()));
            }
            case "ParentReference": {
                return Optional.ofNullable(clazz.cast(this.parentReference()));
            }
            case "LinkName": {
                return Optional.ofNullable(clazz.cast(this.linkName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x-amz-data-partition", DIRECTORY_ARN_FIELD);
        map.put("SchemaFacets", SCHEMA_FACETS_FIELD);
        map.put("ObjectAttributeList", OBJECT_ATTRIBUTE_LIST_FIELD);
        map.put("ParentReference", PARENT_REFERENCE_FIELD);
        map.put("LinkName", LINK_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateObjectRequest, T> g) {
        return obj -> g.apply((CreateObjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private List<SchemaFacet> schemaFacets = DefaultSdkAutoConstructList.getInstance();
        private List<AttributeKeyAndValue> objectAttributeList = DefaultSdkAutoConstructList.getInstance();
        private ObjectReference parentReference;
        private String linkName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateObjectRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.schemaFacets(model.schemaFacets);
            this.objectAttributeList(model.objectAttributeList);
            this.parentReference(model.parentReference);
            this.linkName(model.linkName);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final List<SchemaFacet.Builder> getSchemaFacets() {
            List<SchemaFacet.Builder> result = SchemaFacetListCopier.copyToBuilder(this.schemaFacets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSchemaFacets(Collection<SchemaFacet.BuilderImpl> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copyFromBuilder(schemaFacets);
        }

        @Override
        public final Builder schemaFacets(Collection<SchemaFacet> schemaFacets) {
            this.schemaFacets = SchemaFacetListCopier.copy(schemaFacets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(SchemaFacet ... schemaFacets) {
            this.schemaFacets(Arrays.asList(schemaFacets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaFacets(Consumer<SchemaFacet.Builder> ... schemaFacets) {
            this.schemaFacets(Stream.of(schemaFacets).map(c -> (SchemaFacet)((SchemaFacet.Builder)SchemaFacet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AttributeKeyAndValue.Builder> getObjectAttributeList() {
            List<AttributeKeyAndValue.Builder> result = AttributeKeyAndValueListCopier.copyToBuilder(this.objectAttributeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectAttributeList(Collection<AttributeKeyAndValue.BuilderImpl> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copyFromBuilder(objectAttributeList);
        }

        @Override
        public final Builder objectAttributeList(Collection<AttributeKeyAndValue> objectAttributeList) {
            this.objectAttributeList = AttributeKeyAndValueListCopier.copy(objectAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(AttributeKeyAndValue ... objectAttributeList) {
            this.objectAttributeList(Arrays.asList(objectAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... objectAttributeList) {
            this.objectAttributeList(Stream.of(objectAttributeList).map(c -> (AttributeKeyAndValue)((AttributeKeyAndValue.Builder)AttributeKeyAndValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ObjectReference.Builder getParentReference() {
            return this.parentReference != null ? this.parentReference.toBuilder() : null;
        }

        public final void setParentReference(ObjectReference.BuilderImpl parentReference) {
            this.parentReference = parentReference != null ? parentReference.build() : null;
        }

        @Override
        public final Builder parentReference(ObjectReference parentReference) {
            this.parentReference = parentReference;
            return this;
        }

        public final String getLinkName() {
            return this.linkName;
        }

        public final void setLinkName(String linkName) {
            this.linkName = linkName;
        }

        @Override
        public final Builder linkName(String linkName) {
            this.linkName = linkName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateObjectRequest build() {
            return new CreateObjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateObjectRequest> {
        public Builder directoryArn(String var1);

        public Builder schemaFacets(Collection<SchemaFacet> var1);

        public Builder schemaFacets(SchemaFacet ... var1);

        public Builder schemaFacets(Consumer<SchemaFacet.Builder> ... var1);

        public Builder objectAttributeList(Collection<AttributeKeyAndValue> var1);

        public Builder objectAttributeList(AttributeKeyAndValue ... var1);

        public Builder objectAttributeList(Consumer<AttributeKeyAndValue.Builder> ... var1);

        public Builder parentReference(ObjectReference var1);

        default public Builder parentReference(Consumer<ObjectReference.Builder> parentReference) {
            return this.parentReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(parentReference)).build());
        }

        public Builder linkName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

