/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListManagedSchemaArnsResponse;

public class ListManagedSchemaArnsPublisher
implements SdkPublisher<ListManagedSchemaArnsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListManagedSchemaArnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListManagedSchemaArnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListManagedSchemaArnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedSchemaArnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedSchemaArnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListManagedSchemaArnsPublisher resume(ListManagedSchemaArnsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListManagedSchemaArnsPublisher(this.client, (ListManagedSchemaArnsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListManagedSchemaArnsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListManagedSchemaArnsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListManagedSchemaArnsResponseFetcher
    implements AsyncPageFetcher<ListManagedSchemaArnsResponse> {
        private ListManagedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedSchemaArnsResponse> nextPage(ListManagedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedSchemaArnsPublisher.this.client.listManagedSchemaArns(ListManagedSchemaArnsPublisher.this.firstRequest);
            }
            return ListManagedSchemaArnsPublisher.this.client.listManagedSchemaArns((ListManagedSchemaArnsRequest)((Object)ListManagedSchemaArnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

