/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.BatchAddFacetToObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachPolicy;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachToIndex;
import software.amazon.awssdk.services.clouddirectory.model.BatchAttachTypedLink;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateIndex;
import software.amazon.awssdk.services.clouddirectory.model.BatchCreateObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDeleteObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachFromIndex;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachPolicy;
import software.amazon.awssdk.services.clouddirectory.model.BatchDetachTypedLink;
import software.amazon.awssdk.services.clouddirectory.model.BatchRemoveFacetFromObject;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateLinkAttributes;
import software.amazon.awssdk.services.clouddirectory.model.BatchUpdateObjectAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchWriteOperation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchWriteOperation> {
    private static final SdkField<BatchCreateObject> CREATE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateObject").getter(BatchWriteOperation.getter(BatchWriteOperation::createObject)).setter(BatchWriteOperation.setter(Builder::createObject)).constructor(BatchCreateObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateObject").build()}).build();
    private static final SdkField<BatchAttachObject> ATTACH_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachObject").getter(BatchWriteOperation.getter(BatchWriteOperation::attachObject)).setter(BatchWriteOperation.setter(Builder::attachObject)).constructor(BatchAttachObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachObject").build()}).build();
    private static final SdkField<BatchDetachObject> DETACH_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachObject").getter(BatchWriteOperation.getter(BatchWriteOperation::detachObject)).setter(BatchWriteOperation.setter(Builder::detachObject)).constructor(BatchDetachObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachObject").build()}).build();
    private static final SdkField<BatchUpdateObjectAttributes> UPDATE_OBJECT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateObjectAttributes").getter(BatchWriteOperation.getter(BatchWriteOperation::updateObjectAttributes)).setter(BatchWriteOperation.setter(Builder::updateObjectAttributes)).constructor(BatchUpdateObjectAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateObjectAttributes").build()}).build();
    private static final SdkField<BatchDeleteObject> DELETE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeleteObject").getter(BatchWriteOperation.getter(BatchWriteOperation::deleteObject)).setter(BatchWriteOperation.setter(Builder::deleteObject)).constructor(BatchDeleteObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteObject").build()}).build();
    private static final SdkField<BatchAddFacetToObject> ADD_FACET_TO_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AddFacetToObject").getter(BatchWriteOperation.getter(BatchWriteOperation::addFacetToObject)).setter(BatchWriteOperation.setter(Builder::addFacetToObject)).constructor(BatchAddFacetToObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddFacetToObject").build()}).build();
    private static final SdkField<BatchRemoveFacetFromObject> REMOVE_FACET_FROM_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RemoveFacetFromObject").getter(BatchWriteOperation.getter(BatchWriteOperation::removeFacetFromObject)).setter(BatchWriteOperation.setter(Builder::removeFacetFromObject)).constructor(BatchRemoveFacetFromObject::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoveFacetFromObject").build()}).build();
    private static final SdkField<BatchAttachPolicy> ATTACH_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachPolicy").getter(BatchWriteOperation.getter(BatchWriteOperation::attachPolicy)).setter(BatchWriteOperation.setter(Builder::attachPolicy)).constructor(BatchAttachPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachPolicy").build()}).build();
    private static final SdkField<BatchDetachPolicy> DETACH_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachPolicy").getter(BatchWriteOperation.getter(BatchWriteOperation::detachPolicy)).setter(BatchWriteOperation.setter(Builder::detachPolicy)).constructor(BatchDetachPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachPolicy").build()}).build();
    private static final SdkField<BatchCreateIndex> CREATE_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreateIndex").getter(BatchWriteOperation.getter(BatchWriteOperation::createIndex)).setter(BatchWriteOperation.setter(Builder::createIndex)).constructor(BatchCreateIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateIndex").build()}).build();
    private static final SdkField<BatchAttachToIndex> ATTACH_TO_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachToIndex").getter(BatchWriteOperation.getter(BatchWriteOperation::attachToIndex)).setter(BatchWriteOperation.setter(Builder::attachToIndex)).constructor(BatchAttachToIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachToIndex").build()}).build();
    private static final SdkField<BatchDetachFromIndex> DETACH_FROM_INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachFromIndex").getter(BatchWriteOperation.getter(BatchWriteOperation::detachFromIndex)).setter(BatchWriteOperation.setter(Builder::detachFromIndex)).constructor(BatchDetachFromIndex::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachFromIndex").build()}).build();
    private static final SdkField<BatchAttachTypedLink> ATTACH_TYPED_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttachTypedLink").getter(BatchWriteOperation.getter(BatchWriteOperation::attachTypedLink)).setter(BatchWriteOperation.setter(Builder::attachTypedLink)).constructor(BatchAttachTypedLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTypedLink").build()}).build();
    private static final SdkField<BatchDetachTypedLink> DETACH_TYPED_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DetachTypedLink").getter(BatchWriteOperation.getter(BatchWriteOperation::detachTypedLink)).setter(BatchWriteOperation.setter(Builder::detachTypedLink)).constructor(BatchDetachTypedLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetachTypedLink").build()}).build();
    private static final SdkField<BatchUpdateLinkAttributes> UPDATE_LINK_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateLinkAttributes").getter(BatchWriteOperation.getter(BatchWriteOperation::updateLinkAttributes)).setter(BatchWriteOperation.setter(Builder::updateLinkAttributes)).constructor(BatchUpdateLinkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateLinkAttributes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_OBJECT_FIELD, ATTACH_OBJECT_FIELD, DETACH_OBJECT_FIELD, UPDATE_OBJECT_ATTRIBUTES_FIELD, DELETE_OBJECT_FIELD, ADD_FACET_TO_OBJECT_FIELD, REMOVE_FACET_FROM_OBJECT_FIELD, ATTACH_POLICY_FIELD, DETACH_POLICY_FIELD, CREATE_INDEX_FIELD, ATTACH_TO_INDEX_FIELD, DETACH_FROM_INDEX_FIELD, ATTACH_TYPED_LINK_FIELD, DETACH_TYPED_LINK_FIELD, UPDATE_LINK_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("CreateObject", CREATE_OBJECT_FIELD);
            this.put("AttachObject", ATTACH_OBJECT_FIELD);
            this.put("DetachObject", DETACH_OBJECT_FIELD);
            this.put("UpdateObjectAttributes", UPDATE_OBJECT_ATTRIBUTES_FIELD);
            this.put("DeleteObject", DELETE_OBJECT_FIELD);
            this.put("AddFacetToObject", ADD_FACET_TO_OBJECT_FIELD);
            this.put("RemoveFacetFromObject", REMOVE_FACET_FROM_OBJECT_FIELD);
            this.put("AttachPolicy", ATTACH_POLICY_FIELD);
            this.put("DetachPolicy", DETACH_POLICY_FIELD);
            this.put("CreateIndex", CREATE_INDEX_FIELD);
            this.put("AttachToIndex", ATTACH_TO_INDEX_FIELD);
            this.put("DetachFromIndex", DETACH_FROM_INDEX_FIELD);
            this.put("AttachTypedLink", ATTACH_TYPED_LINK_FIELD);
            this.put("DetachTypedLink", DETACH_TYPED_LINK_FIELD);
            this.put("UpdateLinkAttributes", UPDATE_LINK_ATTRIBUTES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final BatchCreateObject createObject;
    private final BatchAttachObject attachObject;
    private final BatchDetachObject detachObject;
    private final BatchUpdateObjectAttributes updateObjectAttributes;
    private final BatchDeleteObject deleteObject;
    private final BatchAddFacetToObject addFacetToObject;
    private final BatchRemoveFacetFromObject removeFacetFromObject;
    private final BatchAttachPolicy attachPolicy;
    private final BatchDetachPolicy detachPolicy;
    private final BatchCreateIndex createIndex;
    private final BatchAttachToIndex attachToIndex;
    private final BatchDetachFromIndex detachFromIndex;
    private final BatchAttachTypedLink attachTypedLink;
    private final BatchDetachTypedLink detachTypedLink;
    private final BatchUpdateLinkAttributes updateLinkAttributes;

    private BatchWriteOperation(BuilderImpl builder) {
        this.createObject = builder.createObject;
        this.attachObject = builder.attachObject;
        this.detachObject = builder.detachObject;
        this.updateObjectAttributes = builder.updateObjectAttributes;
        this.deleteObject = builder.deleteObject;
        this.addFacetToObject = builder.addFacetToObject;
        this.removeFacetFromObject = builder.removeFacetFromObject;
        this.attachPolicy = builder.attachPolicy;
        this.detachPolicy = builder.detachPolicy;
        this.createIndex = builder.createIndex;
        this.attachToIndex = builder.attachToIndex;
        this.detachFromIndex = builder.detachFromIndex;
        this.attachTypedLink = builder.attachTypedLink;
        this.detachTypedLink = builder.detachTypedLink;
        this.updateLinkAttributes = builder.updateLinkAttributes;
    }

    public final BatchCreateObject createObject() {
        return this.createObject;
    }

    public final BatchAttachObject attachObject() {
        return this.attachObject;
    }

    public final BatchDetachObject detachObject() {
        return this.detachObject;
    }

    public final BatchUpdateObjectAttributes updateObjectAttributes() {
        return this.updateObjectAttributes;
    }

    public final BatchDeleteObject deleteObject() {
        return this.deleteObject;
    }

    public final BatchAddFacetToObject addFacetToObject() {
        return this.addFacetToObject;
    }

    public final BatchRemoveFacetFromObject removeFacetFromObject() {
        return this.removeFacetFromObject;
    }

    public final BatchAttachPolicy attachPolicy() {
        return this.attachPolicy;
    }

    public final BatchDetachPolicy detachPolicy() {
        return this.detachPolicy;
    }

    public final BatchCreateIndex createIndex() {
        return this.createIndex;
    }

    public final BatchAttachToIndex attachToIndex() {
        return this.attachToIndex;
    }

    public final BatchDetachFromIndex detachFromIndex() {
        return this.detachFromIndex;
    }

    public final BatchAttachTypedLink attachTypedLink() {
        return this.attachTypedLink;
    }

    public final BatchDetachTypedLink detachTypedLink() {
        return this.detachTypedLink;
    }

    public final BatchUpdateLinkAttributes updateLinkAttributes() {
        return this.updateLinkAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateObjectAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.addFacetToObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeFacetFromObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachToIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachFromIndex());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.detachTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateLinkAttributes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchWriteOperation)) {
            return false;
        }
        BatchWriteOperation other = (BatchWriteOperation)obj;
        return Objects.equals(this.createObject(), other.createObject()) && Objects.equals(this.attachObject(), other.attachObject()) && Objects.equals(this.detachObject(), other.detachObject()) && Objects.equals(this.updateObjectAttributes(), other.updateObjectAttributes()) && Objects.equals(this.deleteObject(), other.deleteObject()) && Objects.equals(this.addFacetToObject(), other.addFacetToObject()) && Objects.equals(this.removeFacetFromObject(), other.removeFacetFromObject()) && Objects.equals(this.attachPolicy(), other.attachPolicy()) && Objects.equals(this.detachPolicy(), other.detachPolicy()) && Objects.equals(this.createIndex(), other.createIndex()) && Objects.equals(this.attachToIndex(), other.attachToIndex()) && Objects.equals(this.detachFromIndex(), other.detachFromIndex()) && Objects.equals(this.attachTypedLink(), other.attachTypedLink()) && Objects.equals(this.detachTypedLink(), other.detachTypedLink()) && Objects.equals(this.updateLinkAttributes(), other.updateLinkAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"BatchWriteOperation").add("CreateObject", (Object)this.createObject()).add("AttachObject", (Object)this.attachObject()).add("DetachObject", (Object)this.detachObject()).add("UpdateObjectAttributes", (Object)this.updateObjectAttributes()).add("DeleteObject", (Object)this.deleteObject()).add("AddFacetToObject", (Object)this.addFacetToObject()).add("RemoveFacetFromObject", (Object)this.removeFacetFromObject()).add("AttachPolicy", (Object)this.attachPolicy()).add("DetachPolicy", (Object)this.detachPolicy()).add("CreateIndex", (Object)this.createIndex()).add("AttachToIndex", (Object)this.attachToIndex()).add("DetachFromIndex", (Object)this.detachFromIndex()).add("AttachTypedLink", (Object)this.attachTypedLink()).add("DetachTypedLink", (Object)this.detachTypedLink()).add("UpdateLinkAttributes", (Object)this.updateLinkAttributes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateObject": {
                return Optional.ofNullable(clazz.cast(this.createObject()));
            }
            case "AttachObject": {
                return Optional.ofNullable(clazz.cast(this.attachObject()));
            }
            case "DetachObject": {
                return Optional.ofNullable(clazz.cast(this.detachObject()));
            }
            case "UpdateObjectAttributes": {
                return Optional.ofNullable(clazz.cast(this.updateObjectAttributes()));
            }
            case "DeleteObject": {
                return Optional.ofNullable(clazz.cast(this.deleteObject()));
            }
            case "AddFacetToObject": {
                return Optional.ofNullable(clazz.cast(this.addFacetToObject()));
            }
            case "RemoveFacetFromObject": {
                return Optional.ofNullable(clazz.cast(this.removeFacetFromObject()));
            }
            case "AttachPolicy": {
                return Optional.ofNullable(clazz.cast(this.attachPolicy()));
            }
            case "DetachPolicy": {
                return Optional.ofNullable(clazz.cast(this.detachPolicy()));
            }
            case "CreateIndex": {
                return Optional.ofNullable(clazz.cast(this.createIndex()));
            }
            case "AttachToIndex": {
                return Optional.ofNullable(clazz.cast(this.attachToIndex()));
            }
            case "DetachFromIndex": {
                return Optional.ofNullable(clazz.cast(this.detachFromIndex()));
            }
            case "AttachTypedLink": {
                return Optional.ofNullable(clazz.cast(this.attachTypedLink()));
            }
            case "DetachTypedLink": {
                return Optional.ofNullable(clazz.cast(this.detachTypedLink()));
            }
            case "UpdateLinkAttributes": {
                return Optional.ofNullable(clazz.cast(this.updateLinkAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchWriteOperation, T> g) {
        return obj -> g.apply((BatchWriteOperation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private BatchCreateObject createObject;
        private BatchAttachObject attachObject;
        private BatchDetachObject detachObject;
        private BatchUpdateObjectAttributes updateObjectAttributes;
        private BatchDeleteObject deleteObject;
        private BatchAddFacetToObject addFacetToObject;
        private BatchRemoveFacetFromObject removeFacetFromObject;
        private BatchAttachPolicy attachPolicy;
        private BatchDetachPolicy detachPolicy;
        private BatchCreateIndex createIndex;
        private BatchAttachToIndex attachToIndex;
        private BatchDetachFromIndex detachFromIndex;
        private BatchAttachTypedLink attachTypedLink;
        private BatchDetachTypedLink detachTypedLink;
        private BatchUpdateLinkAttributes updateLinkAttributes;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchWriteOperation model) {
            this.createObject(model.createObject);
            this.attachObject(model.attachObject);
            this.detachObject(model.detachObject);
            this.updateObjectAttributes(model.updateObjectAttributes);
            this.deleteObject(model.deleteObject);
            this.addFacetToObject(model.addFacetToObject);
            this.removeFacetFromObject(model.removeFacetFromObject);
            this.attachPolicy(model.attachPolicy);
            this.detachPolicy(model.detachPolicy);
            this.createIndex(model.createIndex);
            this.attachToIndex(model.attachToIndex);
            this.detachFromIndex(model.detachFromIndex);
            this.attachTypedLink(model.attachTypedLink);
            this.detachTypedLink(model.detachTypedLink);
            this.updateLinkAttributes(model.updateLinkAttributes);
        }

        public final BatchCreateObject.Builder getCreateObject() {
            return this.createObject != null ? this.createObject.toBuilder() : null;
        }

        public final void setCreateObject(BatchCreateObject.BuilderImpl createObject) {
            this.createObject = createObject != null ? createObject.build() : null;
        }

        @Override
        public final Builder createObject(BatchCreateObject createObject) {
            this.createObject = createObject;
            return this;
        }

        public final BatchAttachObject.Builder getAttachObject() {
            return this.attachObject != null ? this.attachObject.toBuilder() : null;
        }

        public final void setAttachObject(BatchAttachObject.BuilderImpl attachObject) {
            this.attachObject = attachObject != null ? attachObject.build() : null;
        }

        @Override
        public final Builder attachObject(BatchAttachObject attachObject) {
            this.attachObject = attachObject;
            return this;
        }

        public final BatchDetachObject.Builder getDetachObject() {
            return this.detachObject != null ? this.detachObject.toBuilder() : null;
        }

        public final void setDetachObject(BatchDetachObject.BuilderImpl detachObject) {
            this.detachObject = detachObject != null ? detachObject.build() : null;
        }

        @Override
        public final Builder detachObject(BatchDetachObject detachObject) {
            this.detachObject = detachObject;
            return this;
        }

        public final BatchUpdateObjectAttributes.Builder getUpdateObjectAttributes() {
            return this.updateObjectAttributes != null ? this.updateObjectAttributes.toBuilder() : null;
        }

        public final void setUpdateObjectAttributes(BatchUpdateObjectAttributes.BuilderImpl updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes != null ? updateObjectAttributes.build() : null;
        }

        @Override
        public final Builder updateObjectAttributes(BatchUpdateObjectAttributes updateObjectAttributes) {
            this.updateObjectAttributes = updateObjectAttributes;
            return this;
        }

        public final BatchDeleteObject.Builder getDeleteObject() {
            return this.deleteObject != null ? this.deleteObject.toBuilder() : null;
        }

        public final void setDeleteObject(BatchDeleteObject.BuilderImpl deleteObject) {
            this.deleteObject = deleteObject != null ? deleteObject.build() : null;
        }

        @Override
        public final Builder deleteObject(BatchDeleteObject deleteObject) {
            this.deleteObject = deleteObject;
            return this;
        }

        public final BatchAddFacetToObject.Builder getAddFacetToObject() {
            return this.addFacetToObject != null ? this.addFacetToObject.toBuilder() : null;
        }

        public final void setAddFacetToObject(BatchAddFacetToObject.BuilderImpl addFacetToObject) {
            this.addFacetToObject = addFacetToObject != null ? addFacetToObject.build() : null;
        }

        @Override
        public final Builder addFacetToObject(BatchAddFacetToObject addFacetToObject) {
            this.addFacetToObject = addFacetToObject;
            return this;
        }

        public final BatchRemoveFacetFromObject.Builder getRemoveFacetFromObject() {
            return this.removeFacetFromObject != null ? this.removeFacetFromObject.toBuilder() : null;
        }

        public final void setRemoveFacetFromObject(BatchRemoveFacetFromObject.BuilderImpl removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject != null ? removeFacetFromObject.build() : null;
        }

        @Override
        public final Builder removeFacetFromObject(BatchRemoveFacetFromObject removeFacetFromObject) {
            this.removeFacetFromObject = removeFacetFromObject;
            return this;
        }

        public final BatchAttachPolicy.Builder getAttachPolicy() {
            return this.attachPolicy != null ? this.attachPolicy.toBuilder() : null;
        }

        public final void setAttachPolicy(BatchAttachPolicy.BuilderImpl attachPolicy) {
            this.attachPolicy = attachPolicy != null ? attachPolicy.build() : null;
        }

        @Override
        public final Builder attachPolicy(BatchAttachPolicy attachPolicy) {
            this.attachPolicy = attachPolicy;
            return this;
        }

        public final BatchDetachPolicy.Builder getDetachPolicy() {
            return this.detachPolicy != null ? this.detachPolicy.toBuilder() : null;
        }

        public final void setDetachPolicy(BatchDetachPolicy.BuilderImpl detachPolicy) {
            this.detachPolicy = detachPolicy != null ? detachPolicy.build() : null;
        }

        @Override
        public final Builder detachPolicy(BatchDetachPolicy detachPolicy) {
            this.detachPolicy = detachPolicy;
            return this;
        }

        public final BatchCreateIndex.Builder getCreateIndex() {
            return this.createIndex != null ? this.createIndex.toBuilder() : null;
        }

        public final void setCreateIndex(BatchCreateIndex.BuilderImpl createIndex) {
            this.createIndex = createIndex != null ? createIndex.build() : null;
        }

        @Override
        public final Builder createIndex(BatchCreateIndex createIndex) {
            this.createIndex = createIndex;
            return this;
        }

        public final BatchAttachToIndex.Builder getAttachToIndex() {
            return this.attachToIndex != null ? this.attachToIndex.toBuilder() : null;
        }

        public final void setAttachToIndex(BatchAttachToIndex.BuilderImpl attachToIndex) {
            this.attachToIndex = attachToIndex != null ? attachToIndex.build() : null;
        }

        @Override
        public final Builder attachToIndex(BatchAttachToIndex attachToIndex) {
            this.attachToIndex = attachToIndex;
            return this;
        }

        public final BatchDetachFromIndex.Builder getDetachFromIndex() {
            return this.detachFromIndex != null ? this.detachFromIndex.toBuilder() : null;
        }

        public final void setDetachFromIndex(BatchDetachFromIndex.BuilderImpl detachFromIndex) {
            this.detachFromIndex = detachFromIndex != null ? detachFromIndex.build() : null;
        }

        @Override
        public final Builder detachFromIndex(BatchDetachFromIndex detachFromIndex) {
            this.detachFromIndex = detachFromIndex;
            return this;
        }

        public final BatchAttachTypedLink.Builder getAttachTypedLink() {
            return this.attachTypedLink != null ? this.attachTypedLink.toBuilder() : null;
        }

        public final void setAttachTypedLink(BatchAttachTypedLink.BuilderImpl attachTypedLink) {
            this.attachTypedLink = attachTypedLink != null ? attachTypedLink.build() : null;
        }

        @Override
        public final Builder attachTypedLink(BatchAttachTypedLink attachTypedLink) {
            this.attachTypedLink = attachTypedLink;
            return this;
        }

        public final BatchDetachTypedLink.Builder getDetachTypedLink() {
            return this.detachTypedLink != null ? this.detachTypedLink.toBuilder() : null;
        }

        public final void setDetachTypedLink(BatchDetachTypedLink.BuilderImpl detachTypedLink) {
            this.detachTypedLink = detachTypedLink != null ? detachTypedLink.build() : null;
        }

        @Override
        public final Builder detachTypedLink(BatchDetachTypedLink detachTypedLink) {
            this.detachTypedLink = detachTypedLink;
            return this;
        }

        public final BatchUpdateLinkAttributes.Builder getUpdateLinkAttributes() {
            return this.updateLinkAttributes != null ? this.updateLinkAttributes.toBuilder() : null;
        }

        public final void setUpdateLinkAttributes(BatchUpdateLinkAttributes.BuilderImpl updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes != null ? updateLinkAttributes.build() : null;
        }

        @Override
        public final Builder updateLinkAttributes(BatchUpdateLinkAttributes updateLinkAttributes) {
            this.updateLinkAttributes = updateLinkAttributes;
            return this;
        }

        public BatchWriteOperation build() {
            return new BatchWriteOperation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchWriteOperation> {
        public Builder createObject(BatchCreateObject var1);

        default public Builder createObject(Consumer<BatchCreateObject.Builder> createObject) {
            return this.createObject((BatchCreateObject)((BatchCreateObject.Builder)BatchCreateObject.builder().applyMutation(createObject)).build());
        }

        public Builder attachObject(BatchAttachObject var1);

        default public Builder attachObject(Consumer<BatchAttachObject.Builder> attachObject) {
            return this.attachObject((BatchAttachObject)((BatchAttachObject.Builder)BatchAttachObject.builder().applyMutation(attachObject)).build());
        }

        public Builder detachObject(BatchDetachObject var1);

        default public Builder detachObject(Consumer<BatchDetachObject.Builder> detachObject) {
            return this.detachObject((BatchDetachObject)((BatchDetachObject.Builder)BatchDetachObject.builder().applyMutation(detachObject)).build());
        }

        public Builder updateObjectAttributes(BatchUpdateObjectAttributes var1);

        default public Builder updateObjectAttributes(Consumer<BatchUpdateObjectAttributes.Builder> updateObjectAttributes) {
            return this.updateObjectAttributes((BatchUpdateObjectAttributes)((BatchUpdateObjectAttributes.Builder)BatchUpdateObjectAttributes.builder().applyMutation(updateObjectAttributes)).build());
        }

        public Builder deleteObject(BatchDeleteObject var1);

        default public Builder deleteObject(Consumer<BatchDeleteObject.Builder> deleteObject) {
            return this.deleteObject((BatchDeleteObject)((BatchDeleteObject.Builder)BatchDeleteObject.builder().applyMutation(deleteObject)).build());
        }

        public Builder addFacetToObject(BatchAddFacetToObject var1);

        default public Builder addFacetToObject(Consumer<BatchAddFacetToObject.Builder> addFacetToObject) {
            return this.addFacetToObject((BatchAddFacetToObject)((BatchAddFacetToObject.Builder)BatchAddFacetToObject.builder().applyMutation(addFacetToObject)).build());
        }

        public Builder removeFacetFromObject(BatchRemoveFacetFromObject var1);

        default public Builder removeFacetFromObject(Consumer<BatchRemoveFacetFromObject.Builder> removeFacetFromObject) {
            return this.removeFacetFromObject((BatchRemoveFacetFromObject)((BatchRemoveFacetFromObject.Builder)BatchRemoveFacetFromObject.builder().applyMutation(removeFacetFromObject)).build());
        }

        public Builder attachPolicy(BatchAttachPolicy var1);

        default public Builder attachPolicy(Consumer<BatchAttachPolicy.Builder> attachPolicy) {
            return this.attachPolicy((BatchAttachPolicy)((BatchAttachPolicy.Builder)BatchAttachPolicy.builder().applyMutation(attachPolicy)).build());
        }

        public Builder detachPolicy(BatchDetachPolicy var1);

        default public Builder detachPolicy(Consumer<BatchDetachPolicy.Builder> detachPolicy) {
            return this.detachPolicy((BatchDetachPolicy)((BatchDetachPolicy.Builder)BatchDetachPolicy.builder().applyMutation(detachPolicy)).build());
        }

        public Builder createIndex(BatchCreateIndex var1);

        default public Builder createIndex(Consumer<BatchCreateIndex.Builder> createIndex) {
            return this.createIndex((BatchCreateIndex)((BatchCreateIndex.Builder)BatchCreateIndex.builder().applyMutation(createIndex)).build());
        }

        public Builder attachToIndex(BatchAttachToIndex var1);

        default public Builder attachToIndex(Consumer<BatchAttachToIndex.Builder> attachToIndex) {
            return this.attachToIndex((BatchAttachToIndex)((BatchAttachToIndex.Builder)BatchAttachToIndex.builder().applyMutation(attachToIndex)).build());
        }

        public Builder detachFromIndex(BatchDetachFromIndex var1);

        default public Builder detachFromIndex(Consumer<BatchDetachFromIndex.Builder> detachFromIndex) {
            return this.detachFromIndex((BatchDetachFromIndex)((BatchDetachFromIndex.Builder)BatchDetachFromIndex.builder().applyMutation(detachFromIndex)).build());
        }

        public Builder attachTypedLink(BatchAttachTypedLink var1);

        default public Builder attachTypedLink(Consumer<BatchAttachTypedLink.Builder> attachTypedLink) {
            return this.attachTypedLink((BatchAttachTypedLink)((BatchAttachTypedLink.Builder)BatchAttachTypedLink.builder().applyMutation(attachTypedLink)).build());
        }

        public Builder detachTypedLink(BatchDetachTypedLink var1);

        default public Builder detachTypedLink(Consumer<BatchDetachTypedLink.Builder> detachTypedLink) {
            return this.detachTypedLink((BatchDetachTypedLink)((BatchDetachTypedLink.Builder)BatchDetachTypedLink.builder().applyMutation(detachTypedLink)).build());
        }

        public Builder updateLinkAttributes(BatchUpdateLinkAttributes var1);

        default public Builder updateLinkAttributes(Consumer<BatchUpdateLinkAttributes.Builder> updateLinkAttributes) {
            return this.updateLinkAttributes((BatchUpdateLinkAttributes)((BatchUpdateLinkAttributes.Builder)BatchUpdateLinkAttributes.builder().applyMutation(updateLinkAttributes)).build());
        }
    }
}

