/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.ObjectAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchListIndex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchListIndex> {
    private static final SdkField<List<ObjectAttributeRange>> RANGES_ON_INDEXED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RangesOnIndexedValues").getter(BatchListIndex.getter(BatchListIndex::rangesOnIndexedValues)).setter(BatchListIndex.setter(Builder::rangesOnIndexedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RangesOnIndexedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectAttributeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ObjectReference> INDEX_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IndexReference").getter(BatchListIndex.getter(BatchListIndex::indexReference)).setter(BatchListIndex.setter(Builder::indexReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexReference").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(BatchListIndex.getter(BatchListIndex::maxResults)).setter(BatchListIndex.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(BatchListIndex.getter(BatchListIndex::nextToken)).setter(BatchListIndex.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGES_ON_INDEXED_VALUES_FIELD, INDEX_REFERENCE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RangesOnIndexedValues", RANGES_ON_INDEXED_VALUES_FIELD);
            this.put("IndexReference", INDEX_REFERENCE_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ObjectAttributeRange> rangesOnIndexedValues;
    private final ObjectReference indexReference;
    private final Integer maxResults;
    private final String nextToken;

    private BatchListIndex(BuilderImpl builder) {
        this.rangesOnIndexedValues = builder.rangesOnIndexedValues;
        this.indexReference = builder.indexReference;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRangesOnIndexedValues() {
        return this.rangesOnIndexedValues != null && !(this.rangesOnIndexedValues instanceof SdkAutoConstructList);
    }

    public final List<ObjectAttributeRange> rangesOnIndexedValues() {
        return this.rangesOnIndexedValues;
    }

    public final ObjectReference indexReference() {
        return this.indexReference;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRangesOnIndexedValues() ? this.rangesOnIndexedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.indexReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchListIndex)) {
            return false;
        }
        BatchListIndex other = (BatchListIndex)obj;
        return this.hasRangesOnIndexedValues() == other.hasRangesOnIndexedValues() && Objects.equals(this.rangesOnIndexedValues(), other.rangesOnIndexedValues()) && Objects.equals(this.indexReference(), other.indexReference()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchListIndex").add("RangesOnIndexedValues", this.hasRangesOnIndexedValues() ? this.rangesOnIndexedValues() : null).add("IndexReference", (Object)this.indexReference()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RangesOnIndexedValues": {
                return Optional.ofNullable(clazz.cast(this.rangesOnIndexedValues()));
            }
            case "IndexReference": {
                return Optional.ofNullable(clazz.cast(this.indexReference()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchListIndex, T> g) {
        return obj -> g.apply((BatchListIndex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ObjectAttributeRange> rangesOnIndexedValues = DefaultSdkAutoConstructList.getInstance();
        private ObjectReference indexReference;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchListIndex model) {
            this.rangesOnIndexedValues(model.rangesOnIndexedValues);
            this.indexReference(model.indexReference);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final List<ObjectAttributeRange.Builder> getRangesOnIndexedValues() {
            List<ObjectAttributeRange.Builder> result = ObjectAttributeRangeListCopier.copyToBuilder(this.rangesOnIndexedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRangesOnIndexedValues(Collection<ObjectAttributeRange.BuilderImpl> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copyFromBuilder(rangesOnIndexedValues);
        }

        @Override
        public final Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> rangesOnIndexedValues) {
            this.rangesOnIndexedValues = ObjectAttributeRangeListCopier.copy(rangesOnIndexedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(ObjectAttributeRange ... rangesOnIndexedValues) {
            this.rangesOnIndexedValues(Arrays.asList(rangesOnIndexedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder> ... rangesOnIndexedValues) {
            this.rangesOnIndexedValues(Stream.of(rangesOnIndexedValues).map(c -> (ObjectAttributeRange)((ObjectAttributeRange.Builder)ObjectAttributeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ObjectReference.Builder getIndexReference() {
            return this.indexReference != null ? this.indexReference.toBuilder() : null;
        }

        public final void setIndexReference(ObjectReference.BuilderImpl indexReference) {
            this.indexReference = indexReference != null ? indexReference.build() : null;
        }

        @Override
        public final Builder indexReference(ObjectReference indexReference) {
            this.indexReference = indexReference;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public BatchListIndex build() {
            return new BatchListIndex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchListIndex> {
        public Builder rangesOnIndexedValues(Collection<ObjectAttributeRange> var1);

        public Builder rangesOnIndexedValues(ObjectAttributeRange ... var1);

        public Builder rangesOnIndexedValues(Consumer<ObjectAttributeRange.Builder> ... var1);

        public Builder indexReference(ObjectReference var1);

        default public Builder indexReference(Consumer<ObjectReference.Builder> indexReference) {
            return this.indexReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(indexReference)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);
    }
}

