/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.internal.UserAgentUtils;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListPublishedSchemaArnsResponse;

public class ListPublishedSchemaArnsPublisher
implements SdkPublisher<ListPublishedSchemaArnsResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListPublishedSchemaArnsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPublishedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListPublishedSchemaArnsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPublishedSchemaArnsPublisher(CloudDirectoryAsyncClient client, ListPublishedSchemaArnsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPublishedSchemaArnsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPublishedSchemaArnsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPublishedSchemaArnsResponseFetcher
    implements AsyncPageFetcher<ListPublishedSchemaArnsResponse> {
        private ListPublishedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListPublishedSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPublishedSchemaArnsResponse> nextPage(ListPublishedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListPublishedSchemaArnsPublisher.this.client.listPublishedSchemaArns(ListPublishedSchemaArnsPublisher.this.firstRequest);
            }
            return ListPublishedSchemaArnsPublisher.this.client.listPublishedSchemaArns((ListPublishedSchemaArnsRequest)((Object)ListPublishedSchemaArnsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

