/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClientBuilder;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryServiceClientConfiguration;
import software.amazon.awssdk.services.clouddirectory.DefaultCloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.DefaultCloudDirectoryBaseClientBuilder;
import software.amazon.awssdk.services.clouddirectory.endpoints.CloudDirectoryEndpointProvider;

@SdkInternalApi
final class DefaultCloudDirectoryAsyncClientBuilder
extends DefaultCloudDirectoryBaseClientBuilder<CloudDirectoryAsyncClientBuilder, CloudDirectoryAsyncClient>
implements CloudDirectoryAsyncClientBuilder {
    DefaultCloudDirectoryAsyncClientBuilder() {
    }

    @Override
    public DefaultCloudDirectoryAsyncClientBuilder endpointProvider(CloudDirectoryEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudDirectoryAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultCloudDirectoryAsyncClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudDirectoryServiceClientConfiguration serviceClientConfiguration = CloudDirectoryServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudDirectoryAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

