/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConsistencyLevel {
    SERIALIZABLE("SERIALIZABLE"),
    EVENTUAL("EVENTUAL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConsistencyLevel> VALUE_MAP;
    private final String value;

    private ConsistencyLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConsistencyLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConsistencyLevel> knownValues() {
        EnumSet<ConsistencyLevel> knownValues = EnumSet.allOf(ConsistencyLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConsistencyLevel.class, ConsistencyLevel::toString);
    }
}

