/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListAppliedSchemaArnsResponse;

public class ListAppliedSchemaArnsIterable
implements SdkIterable<ListAppliedSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListAppliedSchemaArnsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAppliedSchemaArnsIterable(CloudDirectoryClient client, ListAppliedSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListAppliedSchemaArnsResponseFetcher();
    }

    public Iterator<ListAppliedSchemaArnsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final ListAppliedSchemaArnsIterable resume(ListAppliedSchemaArnsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListAppliedSchemaArnsIterable(this.client, (ListAppliedSchemaArnsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListAppliedSchemaArnsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListAppliedSchemaArnsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListAppliedSchemaArnsResponseFetcher
    implements SyncPageFetcher<ListAppliedSchemaArnsResponse> {
        private ListAppliedSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListAppliedSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAppliedSchemaArnsResponse nextPage(ListAppliedSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListAppliedSchemaArnsIterable.this.client.listAppliedSchemaArns(ListAppliedSchemaArnsIterable.this.firstRequest);
            }
            return ListAppliedSchemaArnsIterable.this.client.listAppliedSchemaArns((ListAppliedSchemaArnsRequest)((Object)ListAppliedSchemaArnsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

