/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryClient;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDevelopmentSchemaArnsResponse;

public class ListDevelopmentSchemaArnsIterable
implements SdkIterable<ListDevelopmentSchemaArnsResponse> {
    private final CloudDirectoryClient client;
    private final ListDevelopmentSchemaArnsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDevelopmentSchemaArnsIterable(CloudDirectoryClient client, ListDevelopmentSchemaArnsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDevelopmentSchemaArnsResponseFetcher();
    }

    public Iterator<ListDevelopmentSchemaArnsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDevelopmentSchemaArnsResponseFetcher
    implements SyncPageFetcher<ListDevelopmentSchemaArnsResponse> {
        private ListDevelopmentSchemaArnsResponseFetcher() {
        }

        public boolean hasNextPage(ListDevelopmentSchemaArnsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDevelopmentSchemaArnsResponse nextPage(ListDevelopmentSchemaArnsResponse previousPage) {
            if (previousPage == null) {
                return ListDevelopmentSchemaArnsIterable.this.client.listDevelopmentSchemaArns(ListDevelopmentSchemaArnsIterable.this.firstRequest);
            }
            return ListDevelopmentSchemaArnsIterable.this.client.listDevelopmentSchemaArns((ListDevelopmentSchemaArnsRequest)((Object)ListDevelopmentSchemaArnsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

