/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RuleType {
    BINARY_LENGTH("BINARY_LENGTH"),
    NUMBER_COMPARISON("NUMBER_COMPARISON"),
    STRING_FROM_SET("STRING_FROM_SET"),
    STRING_LENGTH("STRING_LENGTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RuleType> VALUE_MAP;
    private final String value;

    private RuleType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RuleType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RuleType> knownValues() {
        EnumSet<RuleType> knownValues = EnumSet.allOf(RuleType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RuleType.class, RuleType::toString);
    }
}

