/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.clouddirectory.CloudDirectoryAsyncClient;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesRequest;
import software.amazon.awssdk.services.clouddirectory.model.ListDirectoriesResponse;

public class ListDirectoriesPublisher
implements SdkPublisher<ListDirectoriesResponse> {
    private final CloudDirectoryAsyncClient client;
    private final ListDirectoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDirectoriesPublisher(CloudDirectoryAsyncClient client, ListDirectoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDirectoriesPublisher(CloudDirectoryAsyncClient client, ListDirectoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDirectoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDirectoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDirectoriesResponseFetcher
    implements AsyncPageFetcher<ListDirectoriesResponse> {
        private ListDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(ListDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDirectoriesResponse> nextPage(ListDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return ListDirectoriesPublisher.this.client.listDirectories(ListDirectoriesPublisher.this.firstRequest);
            }
            return ListDirectoriesPublisher.this.client.listDirectories((ListDirectoriesRequest)((Object)ListDirectoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

