/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPolicyAttachmentsRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ListPolicyAttachmentsRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(ListPolicyAttachmentsRequest.getter(ListPolicyAttachmentsRequest::directoryArn)).setter(ListPolicyAttachmentsRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<ObjectReference> POLICY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyReference").getter(ListPolicyAttachmentsRequest.getter(ListPolicyAttachmentsRequest::policyReference)).setter(ListPolicyAttachmentsRequest.setter(Builder::policyReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyReference").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListPolicyAttachmentsRequest.getter(ListPolicyAttachmentsRequest::nextToken)).setter(ListPolicyAttachmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListPolicyAttachmentsRequest.getter(ListPolicyAttachmentsRequest::maxResults)).setter(ListPolicyAttachmentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsistencyLevel").getter(ListPolicyAttachmentsRequest.getter(ListPolicyAttachmentsRequest::consistencyLevelAsString)).setter(ListPolicyAttachmentsRequest.setter(Builder::consistencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-consistency-level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, POLICY_REFERENCE_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONSISTENCY_LEVEL_FIELD));
    private final String directoryArn;
    private final ObjectReference policyReference;
    private final String nextToken;
    private final Integer maxResults;
    private final String consistencyLevel;

    private ListPolicyAttachmentsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.policyReference = builder.policyReference;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final ObjectReference policyReference() {
        return this.policyReference;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public final String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyAttachmentsRequest)) {
            return false;
        }
        ListPolicyAttachmentsRequest other = (ListPolicyAttachmentsRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.policyReference(), other.policyReference()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListPolicyAttachmentsRequest").add("DirectoryArn", (Object)this.directoryArn()).add("PolicyReference", (Object)this.policyReference()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "PolicyReference": {
                return Optional.ofNullable(clazz.cast(this.policyReference()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPolicyAttachmentsRequest, T> g) {
        return obj -> g.apply((ListPolicyAttachmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference policyReference;
        private String nextToken;
        private Integer maxResults;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyAttachmentsRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.policyReference(model.policyReference);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getPolicyReference() {
            return this.policyReference != null ? this.policyReference.toBuilder() : null;
        }

        @Override
        public final Builder policyReference(ObjectReference policyReference) {
            this.policyReference = policyReference;
            return this;
        }

        public final void setPolicyReference(ObjectReference.BuilderImpl policyReference) {
            this.policyReference = policyReference != null ? policyReference.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPolicyAttachmentsRequest build() {
            return new ListPolicyAttachmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPolicyAttachmentsRequest> {
        public Builder directoryArn(String var1);

        public Builder policyReference(ObjectReference var1);

        default public Builder policyReference(Consumer<ObjectReference.Builder> policyReference) {
            return this.policyReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(policyReference)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

