/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryRequest;
import software.amazon.awssdk.services.clouddirectory.model.ConsistencyLevel;
import software.amazon.awssdk.services.clouddirectory.model.ObjectReference;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRange;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkAttributeRangeListCopier;
import software.amazon.awssdk.services.clouddirectory.model.TypedLinkSchemaAndFacetName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIncomingTypedLinksRequest
extends CloudDirectoryRequest
implements ToCopyableBuilder<Builder, ListIncomingTypedLinksRequest> {
    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryArn").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::directoryArn)).setter(ListIncomingTypedLinksRequest.setter(Builder::directoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-data-partition").build()}).build();
    private static final SdkField<ObjectReference> OBJECT_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ObjectReference").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::objectReference)).setter(ListIncomingTypedLinksRequest.setter(Builder::objectReference)).constructor(ObjectReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectReference").build()}).build();
    private static final SdkField<List<TypedLinkAttributeRange>> FILTER_ATTRIBUTE_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FilterAttributeRanges").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::filterAttributeRanges)).setter(ListIncomingTypedLinksRequest.setter(Builder::filterAttributeRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterAttributeRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TypedLinkAttributeRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TypedLinkSchemaAndFacetName> FILTER_TYPED_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FilterTypedLink").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::filterTypedLink)).setter(ListIncomingTypedLinksRequest.setter(Builder::filterTypedLink)).constructor(TypedLinkSchemaAndFacetName::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterTypedLink").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::nextToken)).setter(ListIncomingTypedLinksRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::maxResults)).setter(ListIncomingTypedLinksRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> CONSISTENCY_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConsistencyLevel").getter(ListIncomingTypedLinksRequest.getter(ListIncomingTypedLinksRequest::consistencyLevelAsString)).setter(ListIncomingTypedLinksRequest.setter(Builder::consistencyLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConsistencyLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ARN_FIELD, OBJECT_REFERENCE_FIELD, FILTER_ATTRIBUTE_RANGES_FIELD, FILTER_TYPED_LINK_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, CONSISTENCY_LEVEL_FIELD));
    private final String directoryArn;
    private final ObjectReference objectReference;
    private final List<TypedLinkAttributeRange> filterAttributeRanges;
    private final TypedLinkSchemaAndFacetName filterTypedLink;
    private final String nextToken;
    private final Integer maxResults;
    private final String consistencyLevel;

    private ListIncomingTypedLinksRequest(BuilderImpl builder) {
        super(builder);
        this.directoryArn = builder.directoryArn;
        this.objectReference = builder.objectReference;
        this.filterAttributeRanges = builder.filterAttributeRanges;
        this.filterTypedLink = builder.filterTypedLink;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.consistencyLevel = builder.consistencyLevel;
    }

    public final String directoryArn() {
        return this.directoryArn;
    }

    public final ObjectReference objectReference() {
        return this.objectReference;
    }

    public final boolean hasFilterAttributeRanges() {
        return this.filterAttributeRanges != null && !(this.filterAttributeRanges instanceof SdkAutoConstructList);
    }

    public final List<TypedLinkAttributeRange> filterAttributeRanges() {
        return this.filterAttributeRanges;
    }

    public final TypedLinkSchemaAndFacetName filterTypedLink() {
        return this.filterTypedLink;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ConsistencyLevel consistencyLevel() {
        return ConsistencyLevel.fromValue(this.consistencyLevel);
    }

    public final String consistencyLevelAsString() {
        return this.consistencyLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilterAttributeRanges() ? this.filterAttributeRanges() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypedLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.consistencyLevelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIncomingTypedLinksRequest)) {
            return false;
        }
        ListIncomingTypedLinksRequest other = (ListIncomingTypedLinksRequest)((Object)obj);
        return Objects.equals(this.directoryArn(), other.directoryArn()) && Objects.equals(this.objectReference(), other.objectReference()) && this.hasFilterAttributeRanges() == other.hasFilterAttributeRanges() && Objects.equals(this.filterAttributeRanges(), other.filterAttributeRanges()) && Objects.equals(this.filterTypedLink(), other.filterTypedLink()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.consistencyLevelAsString(), other.consistencyLevelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListIncomingTypedLinksRequest").add("DirectoryArn", (Object)this.directoryArn()).add("ObjectReference", (Object)this.objectReference()).add("FilterAttributeRanges", this.hasFilterAttributeRanges() ? this.filterAttributeRanges() : null).add("FilterTypedLink", (Object)this.filterTypedLink()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ConsistencyLevel", (Object)this.consistencyLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryArn": {
                return Optional.ofNullable(clazz.cast(this.directoryArn()));
            }
            case "ObjectReference": {
                return Optional.ofNullable(clazz.cast(this.objectReference()));
            }
            case "FilterAttributeRanges": {
                return Optional.ofNullable(clazz.cast(this.filterAttributeRanges()));
            }
            case "FilterTypedLink": {
                return Optional.ofNullable(clazz.cast(this.filterTypedLink()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "ConsistencyLevel": {
                return Optional.ofNullable(clazz.cast(this.consistencyLevelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIncomingTypedLinksRequest, T> g) {
        return obj -> g.apply((ListIncomingTypedLinksRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryArn;
        private ObjectReference objectReference;
        private List<TypedLinkAttributeRange> filterAttributeRanges = DefaultSdkAutoConstructList.getInstance();
        private TypedLinkSchemaAndFacetName filterTypedLink;
        private String nextToken;
        private Integer maxResults;
        private String consistencyLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIncomingTypedLinksRequest model) {
            super(model);
            this.directoryArn(model.directoryArn);
            this.objectReference(model.objectReference);
            this.filterAttributeRanges(model.filterAttributeRanges);
            this.filterTypedLink(model.filterTypedLink);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.consistencyLevel(model.consistencyLevel);
        }

        public final String getDirectoryArn() {
            return this.directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final ObjectReference.Builder getObjectReference() {
            return this.objectReference != null ? this.objectReference.toBuilder() : null;
        }

        @Override
        public final Builder objectReference(ObjectReference objectReference) {
            this.objectReference = objectReference;
            return this;
        }

        public final void setObjectReference(ObjectReference.BuilderImpl objectReference) {
            this.objectReference = objectReference != null ? objectReference.build() : null;
        }

        public final Collection<TypedLinkAttributeRange.Builder> getFilterAttributeRanges() {
            if (this.filterAttributeRanges instanceof SdkAutoConstructList) {
                return null;
            }
            return this.filterAttributeRanges != null ? (Collection)this.filterAttributeRanges.stream().map(TypedLinkAttributeRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copy(filterAttributeRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(TypedLinkAttributeRange ... filterAttributeRanges) {
            this.filterAttributeRanges(Arrays.asList(filterAttributeRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder> ... filterAttributeRanges) {
            this.filterAttributeRanges(Stream.of(filterAttributeRanges).map(c -> (TypedLinkAttributeRange)((TypedLinkAttributeRange.Builder)TypedLinkAttributeRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilterAttributeRanges(Collection<TypedLinkAttributeRange.BuilderImpl> filterAttributeRanges) {
            this.filterAttributeRanges = TypedLinkAttributeRangeListCopier.copyFromBuilder(filterAttributeRanges);
        }

        public final TypedLinkSchemaAndFacetName.Builder getFilterTypedLink() {
            return this.filterTypedLink != null ? this.filterTypedLink.toBuilder() : null;
        }

        @Override
        public final Builder filterTypedLink(TypedLinkSchemaAndFacetName filterTypedLink) {
            this.filterTypedLink = filterTypedLink;
            return this;
        }

        public final void setFilterTypedLink(TypedLinkSchemaAndFacetName.BuilderImpl filterTypedLink) {
            this.filterTypedLink = filterTypedLink != null ? filterTypedLink.build() : null;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getConsistencyLevel() {
            return this.consistencyLevel;
        }

        @Override
        public final Builder consistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        @Override
        public final Builder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.consistencyLevel(consistencyLevel == null ? null : consistencyLevel.toString());
            return this;
        }

        public final void setConsistencyLevel(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIncomingTypedLinksRequest build() {
            return new ListIncomingTypedLinksRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIncomingTypedLinksRequest> {
        public Builder directoryArn(String var1);

        public Builder objectReference(ObjectReference var1);

        default public Builder objectReference(Consumer<ObjectReference.Builder> objectReference) {
            return this.objectReference((ObjectReference)((ObjectReference.Builder)ObjectReference.builder().applyMutation(objectReference)).build());
        }

        public Builder filterAttributeRanges(Collection<TypedLinkAttributeRange> var1);

        public Builder filterAttributeRanges(TypedLinkAttributeRange ... var1);

        public Builder filterAttributeRanges(Consumer<TypedLinkAttributeRange.Builder> ... var1);

        public Builder filterTypedLink(TypedLinkSchemaAndFacetName var1);

        default public Builder filterTypedLink(Consumer<TypedLinkSchemaAndFacetName.Builder> filterTypedLink) {
            return this.filterTypedLink((TypedLinkSchemaAndFacetName)((TypedLinkSchemaAndFacetName.Builder)TypedLinkSchemaAndFacetName.builder().applyMutation(filterTypedLink)).build());
        }

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder consistencyLevel(String var1);

        public Builder consistencyLevel(ConsistencyLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

