/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeAppliedSchemaRequest extends CloudDirectoryRequest implements
        ToCopyableBuilder<UpgradeAppliedSchemaRequest.Builder, UpgradeAppliedSchemaRequest> {
    private static final SdkField<String> PUBLISHED_SCHEMA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublishedSchemaArn").getter(getter(UpgradeAppliedSchemaRequest::publishedSchemaArn))
            .setter(setter(Builder::publishedSchemaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublishedSchemaArn").build())
            .build();

    private static final SdkField<String> DIRECTORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryArn").getter(getter(UpgradeAppliedSchemaRequest::directoryArn))
            .setter(setter(Builder::directoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryArn").build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DryRun").getter(getter(UpgradeAppliedSchemaRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLISHED_SCHEMA_ARN_FIELD,
            DIRECTORY_ARN_FIELD, DRY_RUN_FIELD));

    private final String publishedSchemaArn;

    private final String directoryArn;

    private final Boolean dryRun;

    private UpgradeAppliedSchemaRequest(BuilderImpl builder) {
        super(builder);
        this.publishedSchemaArn = builder.publishedSchemaArn;
        this.directoryArn = builder.directoryArn;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The revision of the published schema to upgrade the directory to.
     * </p>
     * 
     * @return The revision of the published schema to upgrade the directory to.
     */
    public final String publishedSchemaArn() {
        return publishedSchemaArn;
    }

    /**
     * <p>
     * The ARN for the directory to which the upgraded schema will be applied.
     * </p>
     * 
     * @return The ARN for the directory to which the upgraded schema will be applied.
     */
    public final String directoryArn() {
        return directoryArn;
    }

    /**
     * <p>
     * Used for testing whether the major version schemas are backward compatible or not. If schema compatibility fails,
     * an exception would be thrown else the call would succeed but no changes will be saved. This parameter is
     * optional.
     * </p>
     * 
     * @return Used for testing whether the major version schemas are backward compatible or not. If schema
     *         compatibility fails, an exception would be thrown else the call would succeed but no changes will be
     *         saved. This parameter is optional.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(publishedSchemaArn());
        hashCode = 31 * hashCode + Objects.hashCode(directoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeAppliedSchemaRequest)) {
            return false;
        }
        UpgradeAppliedSchemaRequest other = (UpgradeAppliedSchemaRequest) obj;
        return Objects.equals(publishedSchemaArn(), other.publishedSchemaArn())
                && Objects.equals(directoryArn(), other.directoryArn()) && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradeAppliedSchemaRequest").add("PublishedSchemaArn", publishedSchemaArn())
                .add("DirectoryArn", directoryArn()).add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublishedSchemaArn":
            return Optional.ofNullable(clazz.cast(publishedSchemaArn()));
        case "DirectoryArn":
            return Optional.ofNullable(clazz.cast(directoryArn()));
        case "DryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeAppliedSchemaRequest, T> g) {
        return obj -> g.apply((UpgradeAppliedSchemaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudDirectoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpgradeAppliedSchemaRequest> {
        /**
         * <p>
         * The revision of the published schema to upgrade the directory to.
         * </p>
         * 
         * @param publishedSchemaArn
         *        The revision of the published schema to upgrade the directory to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publishedSchemaArn(String publishedSchemaArn);

        /**
         * <p>
         * The ARN for the directory to which the upgraded schema will be applied.
         * </p>
         * 
         * @param directoryArn
         *        The ARN for the directory to which the upgraded schema will be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryArn(String directoryArn);

        /**
         * <p>
         * Used for testing whether the major version schemas are backward compatible or not. If schema compatibility
         * fails, an exception would be thrown else the call would succeed but no changes will be saved. This parameter
         * is optional.
         * </p>
         * 
         * @param dryRun
         *        Used for testing whether the major version schemas are backward compatible or not. If schema
         *        compatibility fails, an exception would be thrown else the call would succeed but no changes will be
         *        saved. This parameter is optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudDirectoryRequest.BuilderImpl implements Builder {
        private String publishedSchemaArn;

        private String directoryArn;

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeAppliedSchemaRequest model) {
            super(model);
            publishedSchemaArn(model.publishedSchemaArn);
            directoryArn(model.directoryArn);
            dryRun(model.dryRun);
        }

        public final String getPublishedSchemaArn() {
            return publishedSchemaArn;
        }

        @Override
        public final Builder publishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
            return this;
        }

        public final void setPublishedSchemaArn(String publishedSchemaArn) {
            this.publishedSchemaArn = publishedSchemaArn;
        }

        public final String getDirectoryArn() {
            return directoryArn;
        }

        @Override
        public final Builder directoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
            return this;
        }

        public final void setDirectoryArn(String directoryArn) {
            this.directoryArn = directoryArn;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpgradeAppliedSchemaRequest build() {
            return new UpgradeAppliedSchemaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
